/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.server.filerepository.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.resizers.configurations.AlphaInterpolation;
import net.coobird.thumbnailator.resizers.configurations.Antialiasing;
import net.coobird.thumbnailator.resizers.configurations.Rendering;
import net.coobird.thumbnailator.resizers.configurations.ScalingMode;
import org.genesys2.server.filerepository.service.ThumbnailGenerator;
import org.springframework.stereotype.Service;

@Service
public class ThumbnailGenerator1
implements ThumbnailGenerator {
    @Override
    public byte[] createThumbnail(Integer width, Integer height, byte[] imageBytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
        Thumbnails.Builder th = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        th.outputFormat("png");
        th.antialiasing(Antialiasing.ON);
        th.alphaInterpolation(AlphaInterpolation.QUALITY);
        th.outputQuality(0.9f);
        th.rendering(Rendering.QUALITY);
        th.scalingMode(ScalingMode.BICUBIC);
        th.crop((Position)Positions.CENTER);
        if (width != null && height != null) {
            th.size(width.intValue(), height.intValue());
        } else if (width != null) {
            th.width(width.intValue());
        } else if (height != null) {
            th.height(height.intValue());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(imageBytes.length);
        th.toOutputStream((OutputStream)os);
        return os.toByteArray();
    }
}

