/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.geomajas.layer.LayerException;
import org.geomajas.layer.hibernate.HibernateFeatureModel;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.temporal.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaVisitor
implements FilterVisitor {
    private static final String HIBERNATE_ID = "id";
    private final Logger log = LoggerFactory.getLogger(CriteriaVisitor.class);
    private String geomName;
    private final int srid;
    private final HibernateFeatureModel featureModel;
    private final DateFormat dateFormat;
    private final List<String> aliases = new ArrayList<String>();

    public CriteriaVisitor(HibernateFeatureModel featureModel, DateFormat dateFormat) {
        this.featureModel = featureModel;
        this.dateFormat = dateFormat;
        this.srid = featureModel.getSrid();
        try {
            this.geomName = featureModel.getGeometryAttributeName();
        }
        catch (LayerException e) {
            this.log.warn("Cannot read geomName, defaulting to 'geometry'", (Throwable)e);
            this.geomName = "geometry";
        }
    }

    public Object visit(And filter, Object userData) {
        Criterion c = null;
        for (Filter element : filter.getChildren()) {
            if (c == null) {
                c = (Criterion)element.accept((FilterVisitor)this, userData);
                continue;
            }
            c = Restrictions.and((Criterion)c, (Criterion)((Criterion)element.accept((FilterVisitor)this, userData)));
        }
        return c;
    }

    public Object visit(Not filter, Object userData) {
        Criterion c = (Criterion)filter.getFilter().accept((FilterVisitor)this, userData);
        return Restrictions.not((Criterion)c);
    }

    public Object visit(Or filter, Object userData) {
        Criterion c = null;
        for (Filter element : filter.getChildren()) {
            if (c == null) {
                c = (Criterion)element.accept((FilterVisitor)this, userData);
                continue;
            }
            c = Restrictions.or((Criterion)c, (Criterion)((Criterion)element.accept((FilterVisitor)this, userData)));
        }
        return c;
    }

    public Object visit(PropertyIsBetween filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object lo = this.castLiteral(this.getLiteralValue(filter.getLowerBoundary()), propertyName);
        Object hi = this.castLiteral(this.getLiteralValue(filter.getUpperBoundary()), propertyName);
        return Restrictions.between((String)finalName, (Object)lo, (Object)hi);
    }

    public Object visit(PropertyIsEqualTo filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object value = this.castLiteral(this.getLiteralValue(filter.getExpression2()), propertyName);
        return Restrictions.eq((String)finalName, (Object)value);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object value = this.castLiteral(this.getLiteralValue(filter.getExpression2()), propertyName);
        return Restrictions.ne((String)finalName, (Object)value);
    }

    public Object visit(PropertyIsGreaterThan filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object literal = this.getLiteralValue(filter.getExpression2());
        return Restrictions.gt((String)finalName, (Object)this.castLiteral(literal, propertyName));
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object literal = this.getLiteralValue(filter.getExpression2());
        return Restrictions.ge((String)finalName, (Object)this.castLiteral(literal, propertyName));
    }

    public Object visit(PropertyIsLessThan filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object literal = this.getLiteralValue(filter.getExpression2());
        return Restrictions.lt((String)finalName, (Object)this.castLiteral(literal, propertyName));
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object literal = this.getLiteralValue(filter.getExpression2());
        return Restrictions.le((String)finalName, (Object)this.castLiteral(literal, propertyName));
    }

    public Object visit(PropertyIsLike filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        String finalName = this.parsePropertyName(propertyName, userData);
        String value = filter.getLiteral();
        value = value.replaceAll("\\*", "%");
        value = value.replaceAll("\\?", "_");
        if (filter.isMatchingCase()) {
            return Restrictions.like((String)finalName, (Object)value);
        }
        return Restrictions.ilike((String)finalName, (Object)value);
    }

    public Object visit(PropertyIsNull filter, Object userData) {
        String propertyName = this.getPropertyName(filter.getExpression());
        String finalName = this.parsePropertyName(propertyName, userData);
        return Restrictions.isNull((String)finalName);
    }

    public Object visit(BBOX filter, Object userData) {
        Envelope env = new Envelope(filter.getMinX(), filter.getMaxX(), filter.getMinY(), filter.getMaxY());
        String finalName = this.parsePropertyName(this.geomName, userData);
        return SpatialRestrictions.filter((String)finalName, (Envelope)env, (int)this.srid);
    }

    public Object visit(Beyond filter, Object userData) {
        throw new UnsupportedOperationException("visit(Beyond filter, Object userData)");
    }

    public Object visit(Contains filter, Object userData) {
        throw new UnsupportedOperationException("visit(Contains filter, Object userData)");
    }

    public Object visit(Crosses filter, Object userData) {
        throw new UnsupportedOperationException("visit(Crosses filter, Object userData)");
    }

    public Object visit(Disjoint filter, Object userData) {
        throw new UnsupportedOperationException("visit(Disjoint filter, Object userData)");
    }

    public Object visit(DWithin filter, Object userData) {
        throw new UnsupportedOperationException("visit(DWithin filter, Object userData)");
    }

    public Object visit(Equals filter, Object userData) {
        throw new UnsupportedOperationException("visit(Equals filter, Object userData)");
    }

    public Object visit(Intersects filter, Object userData) {
        String finalName = this.parsePropertyName(this.geomName, userData);
        return SpatialRestrictions.intersects((String)finalName, (Geometry)this.asGeometry(this.getLiteralValue(filter.getExpression2())));
    }

    public Object visit(Overlaps filter, Object userData) {
        String finalName = this.parsePropertyName(this.geomName, userData);
        return SpatialRestrictions.overlaps((String)finalName, (Geometry)this.asGeometry(this.getLiteralValue(filter.getExpression2())));
    }

    public Object visit(Touches filter, Object userData) {
        String finalName = this.parsePropertyName(this.geomName, userData);
        return SpatialRestrictions.touches((String)finalName, (Geometry)this.asGeometry(this.getLiteralValue(filter.getExpression2())));
    }

    public Object visit(Within filter, Object userData) {
        String finalName = this.parsePropertyName(this.geomName, userData);
        return SpatialRestrictions.within((String)finalName, (Geometry)this.asGeometry(this.getLiteralValue(filter.getExpression2())));
    }

    public Object visit(ExcludeFilter filter, Object userData) {
        return Restrictions.not((Criterion)Restrictions.conjunction());
    }

    public Object visit(IncludeFilter filter, Object userData) {
        return Restrictions.conjunction();
    }

    public Object visit(Id filter, Object userData) {
        String idName;
        try {
            idName = this.featureModel.getEntityMetadata().getIdentifierPropertyName();
        }
        catch (LayerException e) {
            this.log.warn("Cannot read idName, defaulting to 'id'", (Throwable)e);
            idName = HIBERNATE_ID;
        }
        Collection c = (Collection)this.castLiteral(filter.getIdentifiers(), idName);
        return Restrictions.in((String)idName, (Collection)c);
    }

    public Object visitNullFilter(Object userData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(After after, Object extraData) {
        String propertyName = this.getPropertyName(after.getExpression1());
        String finalName = this.parsePropertyName(propertyName, after);
        Object literal = this.getLiteralValue(after.getExpression2());
        if (literal instanceof Date) {
            return Restrictions.gt((String)finalName, (Object)literal);
        }
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(Before before, Object extraData) {
        String propertyName = this.getPropertyName(before.getExpression1());
        String finalName = this.parsePropertyName(propertyName, before);
        Object literal = this.getLiteralValue(before.getExpression2());
        if (literal instanceof Date) {
            return Restrictions.lt((String)finalName, (Object)literal);
        }
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(During during, Object userData) {
        String propertyName = this.getPropertyName(during.getExpression1());
        String finalName = this.parsePropertyName(propertyName, userData);
        Object literal = this.getLiteralValue(during.getExpression2());
        if (literal instanceof Period) {
            Period p = (Period)literal;
            Date begin = p.getBeginning().getPosition().getDate();
            Date end = p.getEnding().getPosition().getDate();
            return Restrictions.between((String)finalName, (Object)begin, (Object)end);
        }
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException("visit(Object userData)");
    }

    private String getPropertyName(Expression expression) {
        if (!(expression instanceof PropertyName)) {
            throw new IllegalArgumentException("Expression " + expression + " is not a PropertyName.");
        }
        String name = ((PropertyName)expression).getPropertyName();
        if (name.endsWith("@id")) {
            name = name.substring(0, name.length() - "@id".length()) + HIBERNATE_ID;
        }
        return name;
    }

    private Object getLiteralValue(Expression expression) {
        if (!(expression instanceof Literal)) {
            throw new IllegalArgumentException("Expression " + expression + " is not a Literal.");
        }
        return ((Literal)expression).getValue();
    }

    private String parsePropertyName(String orgPropertyName, Object userData) {
        String finalName;
        String propertyName = orgPropertyName.replace("/", ".");
        String[] props = propertyName.split("\\.");
        if (props.length > 1 && userData instanceof Criteria) {
            String prevAlias = null;
            for (int i = 0; i < props.length - 1; ++i) {
                String alias = props[i] + "_alias";
                if (!this.aliases.contains(alias)) {
                    Criteria criteria = (Criteria)userData;
                    if (i == 0) {
                        criteria.createAlias(props[0], alias);
                    } else {
                        criteria.createAlias(prevAlias + "." + props[i], alias);
                    }
                    this.aliases.add(alias);
                }
                prevAlias = alias;
            }
            finalName = prevAlias + "." + props[props.length - 1];
        } else {
            finalName = propertyName;
        }
        return finalName;
    }

    private Object castLiteral(Object literal, String propertyName) {
        try {
            if (literal instanceof Collection) {
                return this.castCollection(literal, propertyName);
            }
            if (literal instanceof Object[]) {
                return this.castObjectArray(literal, propertyName);
            }
            Class<?> clazz = this.featureModel.getPropertyClass(this.featureModel.getEntityMetadata(), propertyName);
            if (!clazz.equals(literal.getClass())) {
                if (clazz.equals(Boolean.class)) {
                    return Boolean.valueOf(literal.toString());
                }
                if (clazz.equals(Date.class)) {
                    this.dateFormat.parse(literal.toString());
                } else {
                    if (clazz.equals(Double.class)) {
                        return Double.valueOf(literal.toString());
                    }
                    if (clazz.equals(Float.class)) {
                        return Float.valueOf(literal.toString());
                    }
                    if (clazz.equals(Integer.class)) {
                        return Integer.valueOf(literal.toString());
                    }
                    if (clazz.equals(Long.class)) {
                        return Long.valueOf(literal.toString());
                    }
                    if (clazz.equals(Short.class)) {
                        return Short.valueOf(literal.toString());
                    }
                    if (clazz.equals(String.class)) {
                        return literal.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return literal;
    }

    private Object castCollection(Object literal, String propertyName) {
        try {
            Collection c = (Collection)literal;
            Iterator iterator = c.iterator();
            ArrayList<Object> cast = new ArrayList<Object>();
            while (iterator.hasNext()) {
                cast.add(this.castLiteral(iterator.next(), propertyName));
            }
            return cast;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return literal;
        }
    }

    private Object castObjectArray(Object literal, String propertyName) {
        try {
            Object[] array = (Object[])literal;
            Object[] cast = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                cast[i] = this.castLiteral(array[i], propertyName);
            }
            return cast;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return literal;
        }
    }

    private Geometry asGeometry(Object geometry) {
        if (geometry instanceof Geometry) {
            Geometry geom = (Geometry)geometry;
            geom.setSRID(this.srid);
            return geom;
        }
        throw new IllegalStateException("Cannot handle " + geometry + " as geometry.");
    }
}

