/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geomajas.layer.LayerException;
import org.geomajas.layer.entity.Entity;
import org.geomajas.layer.entity.EntityCollection;
import org.geomajas.layer.entity.EntityMapper;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;

public class HibernateEntityMapper
implements EntityMapper {
    private final SessionFactory sessionFactory;

    public HibernateEntityMapper(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Entity findOrCreateEntity(String dataSourceName, Object id) throws LayerException {
        return new HibernateEntity(dataSourceName, id);
    }

    public Entity asEntity(Object object) throws LayerException {
        if (object == null) {
            throw new LayerException(34);
        }
        return new HibernateEntity(object);
    }

    class HibernateEntityCollection
    implements EntityCollection {
        private String parentName;
        private final ClassMetadata metadata;
        private final Object parent;
        private final Collection objects;

        public HibernateEntityCollection(ClassMetadata parentMetadata, ClassMetadata childMetadata, Object parent, Collection<?> objects) {
            this.objects = objects;
            int i = 0;
            for (Type type : childMetadata.getPropertyTypes()) {
                ManyToOneType mto;
                if (type instanceof ManyToOneType && (mto = (ManyToOneType)type).getAssociatedEntityName().equals(parentMetadata.getEntityName())) {
                    this.parentName = childMetadata.getPropertyNames()[i];
                }
                ++i;
            }
            this.metadata = childMetadata;
            this.parent = parent;
        }

        public Iterator<Entity> iterator() {
            ArrayList<HibernateEntity> entities = new ArrayList<HibernateEntity>();
            for (Object bean : this.objects) {
                entities.add(new HibernateEntity(bean));
            }
            return entities.iterator();
        }

        public void addEntity(Entity entity) throws LayerException {
            Object object = ((HibernateEntity)entity).getObject();
            if (this.parentName != null) {
                this.metadata.setPropertyValue(object, this.parentName, this.parent, EntityMode.POJO);
            }
            this.objects.add(object);
        }

        public void removeEntity(Entity entity) throws LayerException {
            Object object = ((HibernateEntity)entity).getObject();
            if (this.parentName != null) {
                this.metadata.setPropertyValue(object, this.parentName, null, EntityMode.POJO);
            }
            this.objects.remove(object);
        }
    }

    class HibernateEntity
    implements Entity {
        private Object object;
        private final ClassMetadata metadata;

        public HibernateEntity(String dataSourceName, Object id) {
            this.metadata = HibernateEntityMapper.this.sessionFactory.getClassMetadata(dataSourceName);
            if (id != null) {
                this.object = HibernateEntityMapper.this.sessionFactory.getCurrentSession().get(dataSourceName, (Serializable)id);
            }
            if (this.object == null) {
                this.object = this.metadata.instantiate(null, (SessionImplementor)HibernateEntityMapper.this.sessionFactory.getCurrentSession());
            }
        }

        public HibernateEntity(Object object) {
            this.object = object;
            this.metadata = HibernateEntityMapper.this.sessionFactory.getClassMetadata(object.getClass());
        }

        public Object getObject() {
            return this.object;
        }

        public Object getId(String name) throws LayerException {
            return this.metadata.getIdentifier(this.object, (SessionImplementor)HibernateEntityMapper.this.sessionFactory.getCurrentSession());
        }

        public Entity getChild(String name) throws LayerException {
            Object child = this.object == null ? null : this.metadata.getPropertyValue(this.object, name, EntityMode.POJO);
            return child == null ? null : new HibernateEntity(child);
        }

        public void setChild(String name, Entity entity) throws LayerException {
            if (entity != null) {
                this.metadata.setPropertyValue(this.object, name, ((HibernateEntity)entity).getObject(), EntityMode.POJO);
            } else {
                this.metadata.setPropertyValue(this.object, name, null, EntityMode.POJO);
            }
        }

        public EntityCollection getChildCollection(String name) throws LayerException {
            Type type = this.metadata.getPropertyType(name);
            if (type instanceof CollectionType) {
                CollectionType ct = (CollectionType)type;
                Collection coll = (Collection)this.metadata.getPropertyValue(this.object, name, EntityMode.POJO);
                if (coll == null) {
                    coll = (Collection)ct.instantiate(0);
                    this.metadata.setPropertyValue(this.object, name, (Object)coll, EntityMode.POJO);
                }
                String entityName = ct.getAssociatedEntityName((SessionFactoryImplementor)HibernateEntityMapper.this.sessionFactory);
                ClassMetadata childMetadata = HibernateEntityMapper.this.sessionFactory.getClassMetadata(entityName);
                return new HibernateEntityCollection(this.metadata, childMetadata, this.object, coll);
            }
            throw new LayerException(34);
        }

        public void setAttribute(String name, Object value) throws LayerException {
            this.metadata.setPropertyValue(this.object, name, value, EntityMode.POJO);
        }

        public Object getAttribute(String name) throws LayerException {
            if (this.metadata.getIdentifierPropertyName().equals(name)) {
                return this.getId(name);
            }
            return this.object == null ? null : this.metadata.getPropertyValue(this.object, name, EntityMode.POJO);
        }
    }
}

