/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.geomajas.configuration.AttributeInfo;
import org.geomajas.configuration.VectorLayerInfo;
import org.geomajas.global.GeomajasException;
import org.geomajas.layer.LayerException;
import org.geomajas.layer.entity.Entity;
import org.geomajas.layer.entity.EntityAttributeService;
import org.geomajas.layer.entity.EntityMapper;
import org.geomajas.layer.feature.Attribute;
import org.geomajas.layer.feature.FeatureModel;
import org.geomajas.layer.hibernate.HibernateEntityMapper;
import org.geomajas.layer.hibernate.HibernateLayerException;
import org.geomajas.layer.hibernate.HibernateLayerUtil;
import org.geomajas.service.GeoService;
import org.hibernate.engine.SessionImplementor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class HibernateFeatureModel
extends HibernateLayerUtil
implements FeatureModel {
    @Autowired
    private GeoService geoService;
    private int srid;
    @Autowired
    private EntityAttributeService entityMappingService;
    private EntityMapper entityMapper;

    @Override
    public void setLayerInfo(VectorLayerInfo layerInfo) throws LayerException {
        super.setLayerInfo(layerInfo);
        this.srid = this.geoService.getSridFromCrs(layerInfo.getCrs());
        this.entityMapper = new HibernateEntityMapper(this.getSessionFactory());
    }

    public Attribute getAttribute(Object feature, String name) throws LayerException {
        try {
            return this.entityMappingService.getAttribute(feature, this.getFeatureInfo(), this.entityMapper, name);
        }
        catch (GeomajasException e) {
            throw new LayerException((Throwable)e);
        }
    }

    public Map<String, Attribute> getAttributes(Object feature) throws LayerException {
        try {
            HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
            for (AttributeInfo attribute : this.getFeatureInfo().getAttributes()) {
                String name = attribute.getName();
                if (name.equals(this.getGeometryAttributeName())) continue;
                Attribute value = this.getAttribute(feature, name);
                attribs.put(name, value);
            }
            return attribs;
        }
        catch (Exception e) {
            throw new LayerException((Throwable)e, 51, new Object[]{feature});
        }
    }

    public String getId(Object feature) throws LayerException {
        Entity entity = this.entityMapper.asEntity(feature);
        Object id = entity.getId(this.getFeatureInfo().getIdentifier().getName());
        return id == null ? null : id.toString();
    }

    public Geometry getGeometry(Object feature) throws LayerException {
        Object obj = this.getAttributeRecursively(feature, this.getGeometryAttributeName());
        if (obj == null) {
            return null;
        }
        if (Geometry.class.isAssignableFrom(obj.getClass())) {
            Geometry geom = (Geometry)obj;
            return (Geometry)geom.clone();
        }
        throw new LayerException(52, new Object[]{this.getGeometryAttributeName()});
    }

    public void setAttributes(Object feature, Map<String, Attribute> attributes) throws LayerException {
        this.entityMappingService.setAttributes(feature, this.getFeatureInfo(), this.entityMapper, attributes);
    }

    public void setGeometry(Object feature, Geometry geometry) throws LayerException {
        Entity entity = this.entityMapper.asEntity(feature);
        entity.setAttribute(this.getGeometryAttributeName(), (Object)geometry);
    }

    public Object newInstance() throws LayerException {
        try {
            return this.getEntityMetadata().instantiate(null, (SessionImplementor)this.getSessionFactory().getCurrentSession());
        }
        catch (Exception e) {
            throw new LayerException((Throwable)e, 53, new Object[]{this.getFeatureInfo().getDataSourceName()});
        }
    }

    public Object newInstance(String id) throws LayerException {
        try {
            Serializable ser = (Serializable)ConvertUtils.convert((String)id, (Class)this.getEntityMetadata().getIdentifierType().getReturnedClass());
            return this.getEntityMetadata().instantiate(ser, (SessionImplementor)this.getSessionFactory().getCurrentSession());
        }
        catch (Exception e) {
            throw new LayerException((Throwable)e, 53, new Object[]{this.getFeatureInfo().getDataSourceName()});
        }
    }

    public int getSrid() {
        return this.srid;
    }

    public String getGeometryAttributeName() throws LayerException {
        return this.fixName(this.getFeatureInfo().getGeometryType().getName());
    }

    public boolean canHandle(Object feature) {
        try {
            return this.getEntityMetadata().getEntityName().equals(feature.getClass().getName());
        }
        catch (HibernateLayerException e) {
            return false;
        }
    }

    private String fixName(String name) {
        return name.replace("/", ".");
    }

    private Object getAttributeRecursively(Object feature, String name) throws LayerException {
        Object tempFeature;
        if (feature == null) {
            return null;
        }
        String[] properties = name.split("\\.", 2);
        if (properties[0].equals(this.getFeatureInfo().getIdentifier().getName())) {
            tempFeature = this.getId(feature);
        } else {
            Entity entity = this.entityMapper.asEntity(feature);
            HibernateEntityMapper.HibernateEntity child = (HibernateEntityMapper.HibernateEntity)entity.getChild(properties[0]);
            Object object = tempFeature = child == null ? null : child.getObject();
        }
        if (tempFeature instanceof Collection) {
            Collection features = (Collection)tempFeature;
            Object[] values = new Object[features.size()];
            int count = 0;
            for (Object value : features) {
                if (properties.length == 1) {
                    values[count++] = value;
                    continue;
                }
                values[count++] = this.getAttributeRecursively(value, properties[1]);
            }
            return values;
        }
        if (properties.length == 1 || tempFeature == null) {
            return tempFeature;
        }
        return this.getAttributeRecursively(tempFeature, properties[1]);
    }
}

