/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.ConvertUtils;
import org.geomajas.annotation.Api;
import org.geomajas.configuration.AssociationAttributeInfo;
import org.geomajas.configuration.AttributeInfo;
import org.geomajas.configuration.SortType;
import org.geomajas.configuration.VectorLayerInfo;
import org.geomajas.global.GeomajasException;
import org.geomajas.layer.LayerException;
import org.geomajas.layer.VectorLayer;
import org.geomajas.layer.VectorLayerAssociationSupport;
import org.geomajas.layer.VectorLayerLazyFeatureConversionSupport;
import org.geomajas.layer.feature.Attribute;
import org.geomajas.layer.feature.FeatureModel;
import org.geomajas.layer.hibernate.CriteriaVisitor;
import org.geomajas.layer.hibernate.HibernateFeatureModel;
import org.geomajas.layer.hibernate.HibernateLayerException;
import org.geomajas.layer.hibernate.HibernateLayerUtil;
import org.geomajas.service.DtoConverterService;
import org.geomajas.service.FilterService;
import org.geomajas.service.GeoService;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Api
@Transactional(rollbackFor={Exception.class})
public class HibernateLayer
extends HibernateLayerUtil
implements VectorLayer,
VectorLayerAssociationSupport,
VectorLayerLazyFeatureConversionSupport {
    private FeatureModel featureModel;
    private boolean scrollableResultSet;
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private FilterService filterService;
    @Autowired
    private DtoConverterService converterService;
    @Autowired
    private GeoService geoService;
    @Autowired
    private ApplicationContext applicationContext;
    private CoordinateReferenceSystem crs;
    private int srid;
    private String id;
    private boolean useLazyFeatureConversion = true;

    public String getId() {
        return this.id;
    }

    @Api
    public void setId(String id) {
        this.id = id;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    public boolean useLazyFeatureConversion() {
        return this.useLazyFeatureConversion;
    }

    @Api
    public void setUseLazyFeatureConversion(boolean useLazyFeatureConversion) {
        this.useLazyFeatureConversion = useLazyFeatureConversion;
    }

    @Override
    @Api
    public void setLayerInfo(VectorLayerInfo layerInfo) throws LayerException {
        super.setLayerInfo(layerInfo);
        if (null != this.featureModel) {
            this.featureModel.setLayerInfo(this.getLayerInfo());
        }
    }

    @PostConstruct
    protected void postConstruct() throws GeomajasException {
        this.crs = this.geoService.getCrs2(this.getLayerInfo().getCrs());
        this.srid = this.geoService.getSridFromCrs(this.crs);
        this.filterService.registerFeatureModel(this.featureModel);
        if (null == this.featureModel) {
            HibernateFeatureModel hibernateFeatureModel = (HibernateFeatureModel)this.applicationContext.getBean(HibernateFeatureModel.class);
            hibernateFeatureModel.setSessionFactory(this.getSessionFactory());
            hibernateFeatureModel.setLayerInfo(this.getLayerInfo());
            this.featureModel = hibernateFeatureModel;
        }
    }

    public boolean isCreateCapable() {
        return true;
    }

    public boolean isUpdateCapable() {
        return true;
    }

    public boolean isDeleteCapable() {
        return true;
    }

    @Api
    public void setFeatureModel(FeatureModel featureModel) throws LayerException {
        this.featureModel = featureModel;
        if (null != this.getLayerInfo()) {
            featureModel.setLayerInfo(this.getLayerInfo());
        }
        this.filterService.registerFeatureModel(featureModel);
    }

    @Override
    @Api
    public void setSessionFactory(SessionFactory sessionFactory) throws HibernateLayerException {
        super.setSessionFactory(sessionFactory);
    }

    public Iterator<?> getElements(Filter filter, int offset, int maxResultSize) throws LayerException {
        try {
            CriteriaVisitor visitor;
            Criterion c;
            Session session = this.getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(this.getFeatureInfo().getDataSourceName());
            if (filter != null && filter != Filter.INCLUDE && (c = (Criterion)filter.accept((FilterVisitor)(visitor = new CriteriaVisitor((HibernateFeatureModel)this.featureModel, this.dateFormat)), (Object)criteria)) != null) {
                criteria.add(c);
            }
            if (this.getFeatureInfo().getSortAttributeName() != null) {
                if (SortType.ASC.equals((Object)this.getFeatureInfo().getSortType())) {
                    criteria.addOrder(Order.asc((String)this.getFeatureInfo().getSortAttributeName()));
                } else {
                    criteria.addOrder(Order.desc((String)this.getFeatureInfo().getSortAttributeName()));
                }
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            if (this.isScrollableResultSet()) {
                return new ScrollIterator(criteria.scroll());
            }
            List list = criteria.list();
            return list.iterator();
        }
        catch (HibernateException he) {
            throw new HibernateLayerException(he, 47, this.getFeatureInfo().getDataSourceName(), filter.toString());
        }
    }

    public Object create(Object feature) throws LayerException {
        this.enforceSrid(feature);
        Session session = this.getSessionFactory().getCurrentSession();
        session.save(feature);
        return feature;
    }

    public Object saveOrUpdate(Object feature) throws LayerException {
        this.enforceSrid(feature);
        Session session = this.getSessionFactory().getCurrentSession();
        return session.merge(feature);
    }

    public void delete(String featureId) throws LayerException {
        Session session = this.getSessionFactory().getCurrentSession();
        session.delete(this.getFeature(featureId));
        session.flush();
    }

    public Object read(String featureId) throws LayerException {
        Object object = this.getFeature(featureId);
        if (object == null) {
            throw new LayerException(42, new Object[]{featureId});
        }
        return object;
    }

    public void update(Object feature) throws LayerException {
        Session session = this.getSessionFactory().getCurrentSession();
        session.update(feature);
    }

    public Envelope getBounds() throws LayerException {
        return this.getBounds(this.filterService.createTrueFilter());
    }

    public Envelope getBounds(Filter filter) throws LayerException {
        return this.getBoundsLocal(filter);
    }

    public List<Attribute<?>> getAttributes(String attributeName, Filter filter) throws LayerException {
        Criterion c;
        if (attributeName == null) {
            throw new HibernateLayerException(5, new Object[]{null});
        }
        AssociationAttributeInfo attributeInfo = this.getRecursiveAttributeInfo(attributeName, this.getFeatureInfo().getAttributes());
        Session session = this.getSessionFactory().getCurrentSession();
        Criteria criteria = session.createCriteria(attributeInfo.getFeature().getDataSourceName());
        CriteriaVisitor visitor = new CriteriaVisitor((HibernateFeatureModel)this.getFeatureModel(), this.dateFormat);
        if (filter != null && (c = (Criterion)filter.accept((FilterVisitor)visitor, null)) != null) {
            criteria.add(c);
        }
        ArrayList attributes = new ArrayList();
        for (Object object : criteria.list()) {
            try {
                attributes.add(this.converterService.toDto(object, (AttributeInfo)attributeInfo));
            }
            catch (GeomajasException e) {
                throw new HibernateLayerException(e, 48, attributeName);
            }
        }
        return attributes;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isScrollableResultSet() {
        return this.scrollableResultSet;
    }

    @Api
    public void setScrollableResultSet(boolean scrollableResultSet) {
        this.scrollableResultSet = scrollableResultSet;
    }

    private void enforceSrid(Object feature) throws LayerException {
        Geometry geom = this.getFeatureModel().getGeometry(feature);
        if (null != geom) {
            geom.setSRID(this.srid);
            this.getFeatureModel().setGeometry(feature, geom);
        }
    }

    private Envelope getBoundsLocal(Filter filter) throws LayerException {
        try {
            Session session = this.getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(this.getFeatureInfo().getDataSourceName());
            CriteriaVisitor visitor = new CriteriaVisitor((HibernateFeatureModel)this.getFeatureModel(), this.dateFormat);
            Criterion c = (Criterion)filter.accept((FilterVisitor)visitor, (Object)criteria);
            if (c != null) {
                criteria.add(c);
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List features = criteria.list();
            Envelope bounds = new Envelope();
            for (Object f : features) {
                Envelope geomBounds = this.getFeatureModel().getGeometry(f).getEnvelopeInternal();
                if (geomBounds.isNull()) continue;
                bounds.expandToInclude(geomBounds);
            }
            return bounds;
        }
        catch (HibernateException he) {
            throw new HibernateLayerException(he, 47, this.getFeatureInfo().getDataSourceName(), filter.toString());
        }
    }

    private Object getFeature(String featureId) throws HibernateLayerException {
        Session session = this.getSessionFactory().getCurrentSession();
        return session.get(this.getFeatureInfo().getDataSourceName(), (Serializable)ConvertUtils.convert((String)featureId, (Class)this.getEntityMetadata().getIdentifierType().getReturnedClass()));
    }

    private AssociationAttributeInfo getRecursiveAttributeInfo(String name, List<AttributeInfo> infos) {
        for (AttributeInfo attributeInfo : infos) {
            if (!(attributeInfo instanceof AssociationAttributeInfo)) continue;
            AssociationAttributeInfo associationAttributeInfo = (AssociationAttributeInfo)attributeInfo;
            if (name.equals(attributeInfo.getName())) {
                return associationAttributeInfo;
            }
            if (!name.startsWith(attributeInfo.getName())) continue;
            String childName = name.substring(attributeInfo.getName().length() + 1);
            return this.getRecursiveAttributeInfo(childName, associationAttributeInfo.getFeature().getAttributes());
        }
        return null;
    }

    private static class ScrollIterator
    implements Iterator {
        private final ScrollableResults sr;
        private boolean hasNext;

        public ScrollIterator(ScrollableResults sr) {
            this.sr = sr;
            this.hasNext = sr.first();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            Object o = this.sr.get(0);
            this.hasNext = this.sr.next();
            return o;
        }

        @Override
        public void remove() {
            throw new HibernateException("Unsupported operation: You cannot remove records this way.");
        }
    }
}

