/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate;

import org.geomajas.configuration.FeatureInfo;
import org.geomajas.configuration.VectorLayerInfo;
import org.geomajas.layer.LayerException;
import org.geomajas.layer.hibernate.HibernateLayerException;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

class HibernateLayerUtil {
    public static final String XPATH_SEPARATOR = "/";
    public static final String SEPARATOR = ".";
    public static final String SEPARATOR_REGEXP = "\\.";
    private SessionFactory sessionFactory;
    private ClassMetadata entityMetadata;
    private VectorLayerInfo layerInfo;

    HibernateLayerUtil() {
    }

    public FeatureInfo getFeatureInfo() {
        return this.layerInfo.getFeatureInfo();
    }

    public VectorLayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public void setLayerInfo(VectorLayerInfo layerInfo) throws LayerException {
        this.layerInfo = layerInfo;
        if (null != this.sessionFactory) {
            this.setSessionFactory(this.sessionFactory);
        }
    }

    public ClassMetadata getEntityMetadata() throws HibernateLayerException {
        if (null == this.entityMetadata) {
            throw new HibernateLayerException(45);
        }
        return this.entityMetadata;
    }

    protected Class<?> getPropertyClass(ClassMetadata meta, String propertyName) throws HibernateLayerException {
        if ((propertyName = propertyName.replace(XPATH_SEPARATOR, SEPARATOR)).contains(SEPARATOR)) {
            String directProperty = propertyName.substring(0, propertyName.indexOf(SEPARATOR));
            try {
                Type prop = meta.getPropertyType(directProperty);
                if (prop.isCollectionType()) {
                    CollectionType coll = (CollectionType)prop;
                    prop = coll.getElementType((SessionFactoryImplementor)this.sessionFactory);
                }
                ClassMetadata propMeta = this.sessionFactory.getClassMetadata(prop.getReturnedClass());
                return this.getPropertyClass(propMeta, propertyName.substring(propertyName.indexOf(SEPARATOR) + 1));
            }
            catch (HibernateException e) {
                throw new HibernateLayerException(e, 44, propertyName, meta.getEntityName());
            }
        }
        try {
            return meta.getPropertyType(propertyName).getReturnedClass();
        }
        catch (HibernateException e) {
            throw new HibernateLayerException(e, 44, propertyName, meta.getEntityName());
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) throws HibernateLayerException {
        try {
            this.sessionFactory = sessionFactory;
            if (null != this.layerInfo) {
                this.entityMetadata = sessionFactory.getClassMetadata(this.layerInfo.getFeatureInfo().getDataSourceName());
            }
        }
        catch (Exception e) {
            throw new HibernateLayerException(e, 46);
        }
    }
}

