/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.Connection;
import org.hibernatespatial.AbstractDBGeometryType;

public class HsqlGeometryUserType
extends AbstractDBGeometryType {
    private static final long serialVersionUID = 180L;
    private static final int SRID_LENGTH = 4;
    private static final int[] GEOMETRY_TYPES = new int[]{2005};

    public int[] sqlTypes() {
        return GEOMETRY_TYPES;
    }

    public Geometry convert2JTS(Object object) {
        Geometry geom;
        if (object == null) {
            return null;
        }
        String data = (String)object;
        int srid = Integer.parseInt(data.substring(0, 3));
        try {
            WKTReader reader = new WKTReader();
            geom = reader.read(data.substring(5));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't parse incoming wkt geometry.", e);
        }
        geom.setSRID(srid);
        return geom;
    }

    public Object conv2DBGeometry(Geometry jtsGeom, Connection connection) {
        int srid = jtsGeom.getSRID();
        WKTWriter writer = new WKTWriter();
        String wkt = writer.write(jtsGeom);
        return srid + "|" + wkt;
    }
}

