/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.layer.hibernate.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilterImpl;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;

@Deprecated
public class ExtendedLikeFilterImpl
extends AbstractFilterImpl
implements PropertyIsLike {
    private Expression attribute;
    private String pattern;
    private String wildcardSingle = ".?";
    private String wildcardMulti = ".*";
    private String escape = "\\";
    private Matcher match;
    private boolean matchingCase;

    public static String convertToSQL92(char escape, char multi, char single, String pattern) throws IllegalArgumentException {
        if (escape == '\'' || multi == '\'' || single == '\'') {
            throw new IllegalArgumentException("do not use single quote (') as special char!");
        }
        StringBuilder result = new StringBuilder(pattern.length() + 5);
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == escape) {
                if (i != pattern.length() - 1) {
                    result.append(pattern.charAt(i + 1));
                }
                ++i;
                continue;
            }
            if (chr == single) {
                result.append('_');
                continue;
            }
            if (chr == multi) {
                result.append('%');
                continue;
            }
            if (chr == '\'') {
                result.append('\'');
                result.append('\'');
                continue;
            }
            result.append(chr);
        }
        return result.toString();
    }

    public String getSQL92LikePattern() throws IllegalArgumentException {
        if (this.escape.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> escape char should be of length exactly 1");
        }
        if (this.wildcardSingle.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardSingle char should be of length exactly 1");
        }
        if (this.wildcardMulti.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardMulti char should be of length exactly 1");
        }
        return LikeFilterImpl.convertToSQL92((char)this.escape.charAt(0), (char)this.wildcardMulti.charAt(0), (char)this.wildcardSingle.charAt(0), (boolean)this.isMatchingCase(), (String)this.pattern);
    }

    public void setWildCard(String wildCard) {
        this.wildcardMulti = wildCard;
        this.match = null;
    }

    public void setSingleChar(String singleChar) {
        this.wildcardSingle = singleChar;
        this.match = null;
    }

    public void setEscape(String escape) {
        this.escape = escape;
        this.match = null;
    }

    private Matcher getMatcher() {
        if (this.match == null) {
            char esc = this.escape.charAt(0);
            LOGGER.finer("wildcard " + this.wildcardMulti + " single " + this.wildcardSingle);
            LOGGER.finer("escape " + this.escape + " esc " + esc + " esc == \\ " + (esc == '\\'));
            String escapedWildcardMulti = this.fixSpecials(this.wildcardMulti);
            String escapedWildcardSingle = this.fixSpecials(this.wildcardSingle);
            StringBuilder tmp = new StringBuilder();
            boolean escapedMode = false;
            int i = 0;
            while (i < this.pattern.length()) {
                char chr = this.pattern.charAt(i);
                LOGGER.finer("tmp = " + tmp + " looking at " + chr);
                if (this.pattern.regionMatches(false, i, this.escape, 0, this.escape.length())) {
                    LOGGER.finer("escape ");
                    escapedMode = true;
                    chr = this.pattern.charAt(i += this.escape.length());
                }
                if (this.pattern.regionMatches(false, i, this.wildcardMulti, 0, this.wildcardMulti.length())) {
                    LOGGER.finer("multi wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardMulti);
                    } else {
                        tmp.append(".*");
                    }
                    i += this.wildcardMulti.length();
                    escapedMode = false;
                    continue;
                }
                if (this.pattern.regionMatches(false, i, this.wildcardSingle, 0, this.wildcardSingle.length())) {
                    LOGGER.finer("single wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardSingle);
                    } else {
                        tmp.append(".{1}");
                    }
                    i += this.wildcardSingle.length();
                    escapedMode = false;
                    continue;
                }
                if (this.isSpecial(chr)) {
                    LOGGER.finer("special");
                    tmp.append(this.escape);
                    tmp.append(chr);
                    escapedMode = false;
                    continue;
                }
                tmp.append(chr);
                escapedMode = false;
                ++i;
            }
            String finalPattern = tmp.toString();
            LOGGER.finer("final pattern " + finalPattern);
            Pattern compPattern = Pattern.compile(finalPattern, 66);
            this.match = compPattern.matcher("");
        }
        return this.match;
    }

    protected ExtendedLikeFilterImpl() {
    }

    public final void setValue(Expression value) throws IllegalFilterException {
        this.setExpression(value);
    }

    @Deprecated
    public final Expression getValue() {
        return this.attribute;
    }

    public Expression getExpression() {
        return this.getValue();
    }

    public void setExpression(Expression e) {
        if (!(e instanceof Expression)) {
            throw new IllegalArgumentException("Expression " + e + " should be an Expression.");
        }
        Expression exprAttribute = e;
        if (Filters.getExpressionType((Expression)exprAttribute) == 111) {
            throw new IllegalFilterException("Attempted to add something other than a string attribute expression to a like filter.");
        }
        this.attribute = exprAttribute;
    }

    @Deprecated
    public final void setPattern(Expression p, String wildcardMultiChar, String wildcardOneChar, String escapeString) {
        this.setPattern(p.toString(), wildcardMultiChar, wildcardOneChar, escapeString);
    }

    @Deprecated
    public final void setPattern(String matchPattern, String wildcardMultiChar, String wildcardOneChar, String escapeString) {
        this.setLiteral(matchPattern);
        this.setWildCard(wildcardMultiChar);
        this.setSingleChar(wildcardOneChar);
        this.setEscape(escapeString);
    }

    @Deprecated
    public final String getPattern() {
        return this.getLiteral();
    }

    public String getLiteral() {
        return this.pattern;
    }

    public void setLiteral(String literal) {
        this.pattern = literal;
        this.match = null;
    }

    public boolean evaluate(Object feature) {
        if (this.attribute == null) {
            return false;
        }
        Object value = this.attribute.evaluate(feature);
        if (null == value) {
            return false;
        }
        Matcher matcher = this.getMatcher();
        matcher.reset(value.toString());
        return matcher.matches();
    }

    public String toString() {
        return "[ " + this.attribute.toString() + " like '" + this.pattern + "' ]";
    }

    public String getEscape() {
        return this.escape;
    }

    @Deprecated
    public final String getWildcardMulti() {
        return this.wildcardMulti;
    }

    public String getWildCard() {
        return this.getWildcardMulti();
    }

    @Deprecated
    public final String getWildcardSingle() {
        return this.wildcardSingle;
    }

    public String getSingleChar() {
        return this.getWildcardSingle();
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&';
    }

    private String fixSpecials(String inString) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (this.isSpecial(chr)) {
                tmp.append(this.escape);
                tmp.append(chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LikeFilterImpl) {
            LikeFilterImpl lFilter = (LikeFilterImpl)obj;
            return Filters.getFilterType((Filter)lFilter) == Filters.getFilterType((Filter)this) && lFilter.getExpression().equals(this.attribute) && lFilter.getPattern().equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 37 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsLike)this, extraData);
    }

    public boolean isMatchingCase() {
        return this.matchingCase;
    }

    public void setMatchingCase(boolean matchingCase) {
        this.matchingCase = matchingCase;
    }

    public MultiValuedFilter.MatchAction getMatchAction() {
        throw new UnsupportedOperationException("getMatchAction()");
    }
}

