/*
 * This is part of Geomajas, a GIS framework, http://www.geomajas.org/.
 *
 * Copyright 2008-2012 Geosparc nv, http://www.geosparc.com/, Belgium.
 *
 * The program is available in open source according to the GNU Affero
 * General Public License. All contributions in this program are covered
 * by the Geomajas Contributors License Agreement. For full licensing
 * details, see LICENSE.txt in the project root.
 */
package org.geomajas.layer.hibernate;

import org.geomajas.layer.LayerException;

/**
 * Exception generated by the use of the Hibernate layer model.
 *
 * @author Pieter De Graef
 */
public class HibernateLayerException extends LayerException {

	public HibernateLayerException() {
		super();
	}

	public HibernateLayerException(Throwable ex) {
		super(ex);
	}

	public HibernateLayerException(Throwable ex, int exceptionCode, Object... parameters) {
		super(ex, exceptionCode, parameters);
	}

	public HibernateLayerException(Throwable ex, int exceptionCode) {
		super(ex, exceptionCode);
	}

	public HibernateLayerException(int exceptionCode, Object... parameters) {
		super(exceptionCode, parameters);
	}

	public HibernateLayerException(int exceptionCode) {
		super(exceptionCode);
	}

}