/*
Copyright 2008-2010 Gephi
Authors : Patick J. McSweeney <pjmcswee@syr.edu>
Website : http://www.gephi.org

This file is part of Gephi.

DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

Copyright 2011 Gephi Consortium. All rights reserved.

The contents of this file are subject to the terms of either the GNU
General Public License Version 3 only ("GPL") or the Common
Development and Distribution License("CDDL") (collectively, the
"License"). You may not use this file except in compliance with the
License. You can obtain a copy of the License at
http://gephi.org/about/legal/license-notice/
or /cddl-1.0.txt and /gpl-3.0.txt. See the License for the
specific language governing permissions and limitations under the
License.  When distributing the software, include this License Header
Notice in each file and include the License files at
/cddl-1.0.txt and /gpl-3.0.txt. If applicable, add the following below the
License Header, with the fields enclosed by brackets [] replaced by
your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

If you wish your version of this file to be governed by only the CDDL
or only the GPL Version 3, indicate your decision by adding
"[Contributor] elects to include this software in this distribution
under the [CDDL or GPL Version 3] license." If you do not indicate a
single choice of license, a recipient has the option to distribute
your version of this file under either the CDDL, the GPL Version 3 or
to extend the choice of license to its licensees as provided above.
However, if you add GPL Version 3 code and therefore, elected the GPL
Version 3 license, then the option applies only if the new code is
made subject to such option by the copyright holder.

Contributor(s):

Portions Copyrighted 2011 Gephi Consortium.
*/
package org.gephi.ui.statistics.plugin;

import org.gephi.graph.api.GraphController;
import org.openide.util.Lookup;

/**
 *
 * @author pjmcswee
 */
public class PageRankPanel extends javax.swing.JPanel {

    public PageRankPanel() {
        initComponents();
        
        //Disable directed if the graph is undirecteds
        GraphController graphController = Lookup.getDefault().lookup(GraphController.class);
        if(graphController.getGraphModel().isUndirected()){
            directedRadioButton.setEnabled(false);
        }
    }

    public boolean isDirected() {
        return directedRadioButton.isSelected();
    }

    public double getEpsilon() {
        try {
            return Double.parseDouble(epsilonTextField.getText());
        } catch (Exception e) {
        }
        return 0.001;
    }

    public double getProbability() {
        try {
            return Double.parseDouble(probTextField.getText());
        } catch (Exception e) {
        }
        return 0.85;
    }

    public boolean isEdgeWeight() {
        return edgeWeightCheckbox.isSelected();
    }

    public void setEdgeWeight(boolean edgeWeight) {
        edgeWeightCheckbox.setSelected(edgeWeight);
    }

    public void setDirected(boolean directed) {
        directedButtonGroup.setSelected(directed ? directedRadioButton.getModel() : undirectedRadioButton.getModel(), true);
        if (!directed) {
            directedRadioButton.setEnabled(false);
        }
    }

    public void setEpsilon(double epsilon) {
        epsilonTextField.setText(Double.toString(epsilon));
    }

    public void setProbability(double probability) {
        probTextField.setText(Double.toString(probability));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        directedButtonGroup = new javax.swing.ButtonGroup();
        labelP = new javax.swing.JLabel();
        labelE = new javax.swing.JLabel();
        probTextField = new javax.swing.JTextField();
        epsilonTextField = new javax.swing.JTextField();
        undirectedRadioButton = new javax.swing.JRadioButton();
        directedRadioButton = new javax.swing.JRadioButton();
        jXHeader1 = new org.jdesktop.swingx.JXHeader();
        jXLabel1 = new org.jdesktop.swingx.JXLabel();
        jXLabel2 = new org.jdesktop.swingx.JXLabel();
        edgeWeightCheckbox = new javax.swing.JCheckBox();

        labelP.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.labelP.text")); // NOI18N

        labelE.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.labelE.text")); // NOI18N

        probTextField.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.probTextField.text")); // NOI18N
        probTextField.setMinimumSize(new java.awt.Dimension(59, 25));
        probTextField.setPreferredSize(new java.awt.Dimension(59, 25));

        epsilonTextField.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.epsilonTextField.text")); // NOI18N
        epsilonTextField.setMinimumSize(new java.awt.Dimension(59, 25));
        epsilonTextField.setPreferredSize(new java.awt.Dimension(59, 25));

        directedButtonGroup.add(undirectedRadioButton);
        undirectedRadioButton.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.undirectedRadioButton.text")); // NOI18N

        directedButtonGroup.add(directedRadioButton);
        directedRadioButton.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.directedRadioButton.text")); // NOI18N

        jXHeader1.setDescription(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.jXHeader1.description")); // NOI18N
        jXHeader1.setTitle(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.jXHeader1.title")); // NOI18N

        jXLabel1.setForeground(new java.awt.Color(102, 102, 102));
        jXLabel1.setLineWrap(true);
        jXLabel1.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.jXLabel1.text")); // NOI18N
        jXLabel1.setFont(jXLabel1.getFont().deriveFont(jXLabel1.getFont().getSize()-1f));

        jXLabel2.setForeground(new java.awt.Color(102, 102, 102));
        jXLabel2.setLineWrap(true);
        jXLabel2.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.jXLabel2.text")); // NOI18N
        jXLabel2.setFont(jXLabel2.getFont().deriveFont(jXLabel2.getFont().getSize()-1f));

        edgeWeightCheckbox.setText(org.openide.util.NbBundle.getMessage(PageRankPanel.class, "PageRankPanel.edgeWeightCheckbox.text")); // NOI18N
        edgeWeightCheckbox.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jXHeader1, javax.swing.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(directedRadioButton)
                    .addComponent(undirectedRadioButton))
                .addGap(45, 45, 45)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(edgeWeightCheckbox)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(labelP)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(probTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(labelE)
                                .addGap(45, 45, 45)
                                .addComponent(epsilonTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jXLabel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jXLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(10, 10, 10))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jXHeader1, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(directedRadioButton)
                    .addComponent(labelP)
                    .addComponent(probTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(undirectedRadioButton)
                    .addComponent(jXLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labelE)
                    .addComponent(epsilonTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jXLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(edgeWeightCheckbox)
                .addContainerGap(36, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup directedButtonGroup;
    protected javax.swing.JRadioButton directedRadioButton;
    private javax.swing.JCheckBox edgeWeightCheckbox;
    protected javax.swing.JTextField epsilonTextField;
    private org.jdesktop.swingx.JXHeader jXHeader1;
    private org.jdesktop.swingx.JXLabel jXLabel1;
    private org.jdesktop.swingx.JXLabel jXLabel2;
    private javax.swing.JLabel labelE;
    private javax.swing.JLabel labelP;
    protected javax.swing.JTextField probTextField;
    protected javax.swing.JRadioButton undirectedRadioButton;
    // End of variables declaration//GEN-END:variables
}
