/*
 * Decompiled with CFR 0.152.
 */
package org.gerweck.scala.util.hashing;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0002\u00025\u0011Q\u0002S1tQ\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003\u001dA\u0017m\u001d5j]\u001eT!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tQa]2bY\u0006T!!\u0003\u0006\u0002\u000f\u001d,'o^3dW*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\"E\u0007\u0002!)\tq!\u0003\u0002\u0013!\t1\u0011I\\=SK\u001aDQ\u0001\u0006\u0001\u0005\u0002U\ta\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0002\t\u000be\u0001a\u0011\u0001\u000e\u0002\t9\fW.Z\u000b\u00027A\u0011Ad\b\b\u0003\u001fuI!A\b\t\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003=AAQa\t\u0001\u0007\u0002\u0011\n!\"\u001b8ji&\fG.\u001b>f)\u0005)\u0003C\u0001\u0014/\u001d\t9reB\u0003)\u0005!\u0005\u0011&A\u0007ICND\u0017\t\\4pe&$\b.\u001c\t\u0003/)2Q!\u0001\u0002\t\u0002-\u001a\"A\u000b\b\t\u000bQQC\u0011A\u0017\u0015\u0003%2qa\f\u0016\u0011\u0002\u0007\u0005\u0001G\u0001\u0007ICND\u0017N\\4Ti\u0006$Xm\u0005\u0002/\u001d!)!G\fC\u0001g\u00051A%\u001b8ji\u0012\"\u0012\u0001\u000e\t\u0003\u001fUJ!A\u000e\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006q92\t!O\u0001\u0007kB$\u0017\r^3\u0015\u0005QR\u0004\"B\u001e8\u0001\u0004a\u0014!\u00022zi\u0016\u001c\bcA\b>\u007f%\u0011a\b\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001f\u0001K!!\u0011\t\u0003\t\tKH/\u001a\u0005\u0006q9\"\ta\u0011\u000b\u0003i\u0011CQa\u000f\"A\u0002\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u00079LwNC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%A\u0003\"zi\u0016\u0014UO\u001a4fe\")aJ\fD\u0001\u001f\u00061A-[4fgR$\u0012\u0001\u0010\u0005\u0006#\u0002!\tEU\u0001\ti>\u001cFO]5oOR\t1\u0004C\u0003U\u0001\u0011\u0005Q+\u0001\u0003iCNDGC\u0001\u001fW\u0011\u0015Y4\u000b1\u0001=\u0011\u0015!\u0006\u0001\"\u0001Y)\ta\u0014\fC\u0003[/\u0002\u0007Q)\u0001\u0006csR,')\u001e4gKJDQ\u0001\u0016\u0001\u0005\u0002q#\"\u0001P/\t\u000bmZ\u0006\u0019\u00010\u0011\u0007}\u0013w(D\u0001a\u0015\t\t\u0007#\u0001\u0006d_2dWm\u0019;j_:L!a\u00191\u0003\u0007M+\u0017\u000fC\u0003U\u0001\u0011\u0005Q\rF\u0002=M\"DQa\u001a3A\u0002m\taa\u001d;sS:<\u0007bB5e!\u0003\u0005\rA[\u0001\tK:\u001cw\u000eZ5oOB\u00111N\\\u0007\u0002Y*\u0011QnR\u0001\bG\"\f'o]3u\u0013\tyGNA\u0004DQ\u0006\u00148/\u001a;\t\u000fE\u0004\u0011\u0013!C\u0001e\u0006q\u0001.Y:iI\u0011,g-Y;mi\u0012\u0012T#A:+\u0005)$8&A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018!C;oG\",7m[3e\u0015\tQ\b#\u0001\u0006b]:|G/\u0019;j_:L!\u0001`<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class HashAlgorithm {
    public abstract String name();

    public abstract HashingState initialize();

    public String toString() {
        return this.name();
    }

    public byte[] hash(byte[] bytes) {
        HashingState a = this.initialize();
        a.update(bytes);
        return a.digest();
    }

    public byte[] hash(ByteBuffer byteBuffer) {
        HashingState a = this.initialize();
        a.update(byteBuffer);
        return a.digest();
    }

    public byte[] hash(Seq<Object> bytes) {
        return this.hash((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
    }

    public byte[] hash(String string, Charset encoding) {
        return this.hash(string.getBytes(encoding));
    }

    public Charset hash$default$2() {
        return StandardCharsets.UTF_8;
    }

    public static interface HashingState {
        public void update(byte[] var1);

        public void update(ByteBuffer var1);

        public byte[] digest();
    }
}

