/*
 * Decompiled with CFR 0.152.
 */
package org.gerweck.scala.util.date;

import org.gerweck.scala.util.date.FormatMethods;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public abstract class FormatMethods$class {
    public static final String formatDuration(FormatMethods $this, double seconds) {
        String string;
        boolean bl = seconds >= 0.0;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"Cannot format a negative duration").toString());
        }
        if (seconds == 0.0) {
            string = "0 s";
        } else if (seconds < 9.995E-7) {
            string = "< 1 \u03bcs";
        } else if (seconds < 9.995E-4) {
            double arg$macro$2 = 1000000.0 * seconds;
            string = new StringOps("%.3g \u03bcs").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        } else if (seconds < 0.9995) {
            string = FormatMethods$class.formatMillis$1($this, seconds);
        } else if (seconds < 999.5) {
            string = new StringOps("%.3g s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        } else if (seconds < 999500.0) {
            double arg$macro$4 = 0.001 * seconds;
            string = new StringOps("%.3g ks").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4)}));
        } else {
            string = new StringOps("%.4g s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        return string;
    }

    public static final String formatDuration(FormatMethods $this, float seconds) {
        return $this.formatDuration((double)seconds);
    }

    public static final String formatDuration(FormatMethods $this, FiniteDuration duration) {
        return $this.formatDuration((double)duration.toNanos() * 1.0E-9);
    }

    private static final boolean isMilliPrecision$1(FormatMethods $this, double seconds$1) {
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(1.0E10 * seconds$1)) % 10000000L == 0L;
    }

    private static final String formatMillis$1(FormatMethods $this, double seconds$1) {
        String string;
        if (FormatMethods$class.isMilliPrecision$1($this, seconds$1) && seconds$1 < 1.0) {
            string = new StringBuilder().append(RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(1000.0 * seconds$1))).append((Object)" ms").toString();
        } else {
            double arg$macro$1 = 1000.0 * seconds$1;
            string = new StringOps("%.3g ms").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
        }
        return string;
    }

    public static void $init$(FormatMethods $this) {
    }
}

