package org.gerweck.scala.util.jdbc

import java.io.InputStream
import java.math.BigDecimal
import java.net.URL
import java.sql.ResultSet
import java.util.Map

/** A wrapper around a JDBC
  * `[[http://docs.oracle.com/javase/7/docs/api/java/sql/ResultSet.html java.sql.ResultSet]]`.
  *
  * This is useful to allow you to override or wrap certain methods: you can
  * use this as a base class and override just the methods you care about.
  * Everything else will delegate to the underlying connection.
  *
  * @author Sarah Gerweck <sarah.a180@gmail.com>
  */
class WrappedResultSet(val inner: ResultSet) extends ResultSet with WrapperWrapping[ResultSet] {

  def absolute(x$1: Int): Boolean = inner.absolute(x$1)
  def afterLast(): Unit = inner.afterLast()
  def beforeFirst(): Unit = inner.beforeFirst()
  def cancelRowUpdates(): Unit = inner.cancelRowUpdates()
  def clearWarnings(): Unit = inner.clearWarnings()
  def close(): Unit = inner.close()
  def deleteRow(): Unit = inner.deleteRow()
  def findColumn(x$1: String): Int = inner.findColumn(x$1)
  def first(): Boolean = inner.first()
  def getArray(x$1: String): java.sql.Array = inner.getArray(x$1)
  def getArray(x$1: Int): java.sql.Array = inner.getArray(x$1)
  def getAsciiStream(x$1: String): InputStream = inner.getAsciiStream(x$1)
  def getAsciiStream(x$1: Int): InputStream = inner.getAsciiStream(x$1)
  def getBigDecimal(x$1: String): BigDecimal = inner.getBigDecimal(x$1)
  def getBigDecimal(x$1: Int): BigDecimal = inner.getBigDecimal(x$1)
  @deprecated("1.0", "Deprecated by Java.")
  def getBigDecimal(x$1: String,x$2: Int): BigDecimal = inner.getBigDecimal(x$1, x$2)
  @deprecated("1.0", "Deprecated by Java.")
  def getBigDecimal(x$1: Int,x$2: Int): BigDecimal = inner.getBigDecimal(x$1, x$2)
  def getBinaryStream(x$1: String): InputStream = inner.getBinaryStream(x$1)
  def getBinaryStream(x$1: Int): InputStream = inner.getBinaryStream(x$1)
  def getBlob(x$1: String): java.sql.Blob = inner.getBlob(x$1)
  def getBlob(x$1: Int): java.sql.Blob = inner.getBlob(x$1)
  def getBoolean(x$1: String): Boolean = inner.getBoolean(x$1)
  def getBoolean(x$1: Int): Boolean = inner.getBoolean(x$1)
  def getByte(x$1: String): Byte = inner.getByte(x$1)
  def getByte(x$1: Int): Byte = inner.getByte(x$1)
  def getBytes(x$1: String): Array[Byte] = inner.getBytes(x$1)
  def getBytes(x$1: Int): Array[Byte] = inner.getBytes(x$1)
  def getCharacterStream(x$1: String): java.io.Reader = inner.getCharacterStream(x$1)
  def getCharacterStream(x$1: Int): java.io.Reader = inner.getCharacterStream(x$1)
  def getClob(x$1: String): java.sql.Clob = inner.getClob(x$1)
  def getClob(x$1: Int): java.sql.Clob = inner.getClob(x$1)
  def getConcurrency(): Int = inner.getConcurrency()
  def getCursorName(): String = inner.getCursorName()
  def getDate(x$1: String,x$2: java.util.Calendar): java.sql.Date = inner.getDate(x$1, x$2)
  def getDate(x$1: Int,x$2: java.util.Calendar): java.sql.Date = inner.getDate(x$1, x$2)
  def getDate(x$1: String): java.sql.Date = inner.getDate(x$1)
  def getDate(x$1: Int): java.sql.Date = inner.getDate(x$1)
  def getDouble(x$1: String): Double = inner.getDouble(x$1)
  def getDouble(x$1: Int): Double = inner.getDouble(x$1)
  def getFetchDirection(): Int = inner.getFetchDirection()
  def getFetchSize(): Int = inner.getFetchSize()
  def getFloat(x$1: String): Float = inner.getFloat(x$1)
  def getFloat(x$1: Int): Float = inner.getFloat(x$1)
  def getHoldability(): Int = inner.getHoldability()
  def getInt(x$1: String): Int = inner.getInt(x$1)
  def getInt(x$1: Int): Int = inner.getInt(x$1)
  def getLong(x$1: String): Long = inner.getLong(x$1)
  def getLong(x$1: Int): Long = inner.getLong(x$1)
  def getMetaData(): java.sql.ResultSetMetaData = inner.getMetaData()
  def getNCharacterStream(x$1: String): java.io.Reader = inner.getNCharacterStream(x$1)
  def getNCharacterStream(x$1: Int): java.io.Reader = inner.getNCharacterStream(x$1)
  def getNClob(x$1: String): java.sql.NClob = inner.getNClob(x$1)
  def getNClob(x$1: Int): java.sql.NClob = inner.getNClob(x$1)
  def getNString(x$1: String): String = inner.getNString(x$1)
  def getNString(x$1: Int): String = inner.getNString(x$1)
  def getObject[T](x$1: String,x$2: Class[T]): T = inner.getObject(x$1, x$2)
  def getObject[T](x$1: Int,x$2: Class[T]): T = inner.getObject(x$1, x$2)
  def getObject(x$1: String,x$2: Map[String,Class[_]]): Object = inner.getObject(x$1, x$2)
  def getObject(x$1: Int,x$2: Map[String,Class[_]]): Object = inner.getObject(x$1, x$2)
  def getObject(x$1: String): Object = inner.getObject(x$1)
  def getObject(x$1: Int): Object = inner.getObject(x$1)
  def getRef(x$1: String): java.sql.Ref = inner.getRef(x$1)
  def getRef(x$1: Int): java.sql.Ref = inner.getRef(x$1)
  def getRow(): Int = inner.getRow()
  def getRowId(x$1: String): java.sql.RowId = inner.getRowId(x$1)
  def getRowId(x$1: Int): java.sql.RowId = inner.getRowId(x$1)
  def getSQLXML(x$1: String): java.sql.SQLXML = inner.getSQLXML(x$1)
  def getSQLXML(x$1: Int): java.sql.SQLXML = inner.getSQLXML(x$1)
  def getShort(x$1: String): Short = inner.getShort(x$1)
  def getShort(x$1: Int): Short = inner.getShort(x$1)
  def getStatement(): java.sql.Statement = inner.getStatement()
  def getString(x$1: String): String = inner.getString(x$1)
  def getString(x$1: Int): String = inner.getString(x$1)
  def getTime(x$1: String,x$2: java.util.Calendar): java.sql.Time = inner.getTime(x$1, x$2)
  def getTime(x$1: Int,x$2: java.util.Calendar): java.sql.Time = inner.getTime(x$1, x$2)
  def getTime(x$1: String): java.sql.Time = inner.getTime(x$1)
  def getTime(x$1: Int): java.sql.Time = inner.getTime(x$1)
  def getTimestamp(x$1: String,x$2: java.util.Calendar): java.sql.Timestamp = inner.getTimestamp(x$1, x$2)
  def getTimestamp(x$1: Int,x$2: java.util.Calendar): java.sql.Timestamp = inner.getTimestamp(x$1, x$2)
  def getTimestamp(x$1: String): java.sql.Timestamp = inner.getTimestamp(x$1)
  def getTimestamp(x$1: Int): java.sql.Timestamp = inner.getTimestamp(x$1)
  def getType(): Int = inner.getType()
  def getURL(x$1: String): URL = inner.getURL(x$1)
  def getURL(x$1: Int): URL = inner.getURL(x$1)
  @deprecated("1.0", "Deprecated by Java.")
  def getUnicodeStream(x$1: String): InputStream = inner.getUnicodeStream(x$1)
  @deprecated("1.0", "Deprecated by Java.")
  def getUnicodeStream(x$1: Int): InputStream = inner.getUnicodeStream(x$1)
  def getWarnings(): java.sql.SQLWarning = inner.getWarnings()
  def insertRow(): Unit = inner.insertRow()
  def isAfterLast(): Boolean = inner.isAfterLast()
  def isBeforeFirst(): Boolean = inner.isBeforeFirst()
  def isClosed(): Boolean = inner.isClosed()
  def isFirst(): Boolean = inner.isFirst()
  def isLast(): Boolean = inner.isLast()
  def last(): Boolean = inner.last()
  def moveToCurrentRow(): Unit = inner.moveToCurrentRow()
  def moveToInsertRow(): Unit = inner.moveToInsertRow()
  def next(): Boolean = inner.next()
  def previous(): Boolean = inner.previous()
  def refreshRow(): Unit = inner.refreshRow()
  def relative(x$1: Int): Boolean = inner.relative(x$1)
  def rowDeleted(): Boolean = inner.rowDeleted()
  def rowInserted(): Boolean = inner.rowInserted()
  def rowUpdated(): Boolean = inner.rowUpdated()
  def setFetchDirection(x$1: Int): Unit = inner.setFetchDirection(x$1)
  def setFetchSize(x$1: Int): Unit = inner.setFetchSize(x$1)
  def updateArray(x$1: String,x$2: java.sql.Array): Unit = inner.updateArray(x$1, x$2)
  def updateArray(x$1: Int,x$2: java.sql.Array): Unit = inner.updateArray(x$1, x$2)
  def updateAsciiStream(x$1: String,x$2: InputStream): Unit = inner.updateAsciiStream(x$1, x$2)
  def updateAsciiStream(x$1: Int,x$2: InputStream): Unit = inner.updateAsciiStream(x$1, x$2)
  def updateAsciiStream(x$1: String,x$2: InputStream,x$3: Long): Unit = inner.updateAsciiStream(x$1, x$2, x$3)
  def updateAsciiStream(x$1: Int,x$2: InputStream,x$3: Long): Unit = inner.updateAsciiStream(x$1, x$2, x$3)
  def updateAsciiStream(x$1: String,x$2: InputStream,x$3: Int): Unit = inner.updateAsciiStream(x$1, x$2, x$3)
  def updateAsciiStream(x$1: Int,x$2: InputStream,x$3: Int): Unit = inner.updateAsciiStream(x$1, x$2, x$3)
  def updateBigDecimal(x$1: String,x$2: BigDecimal): Unit = inner.updateBigDecimal(x$1, x$2)
  def updateBigDecimal(x$1: Int,x$2: BigDecimal): Unit = inner.updateBigDecimal(x$1, x$2)
  def updateBinaryStream(x$1: String,x$2: InputStream): Unit = inner.updateBinaryStream(x$1, x$2)
  def updateBinaryStream(x$1: Int,x$2: InputStream): Unit = inner.updateBinaryStream(x$1, x$2)
  def updateBinaryStream(x$1: String,x$2: InputStream,x$3: Long): Unit = inner.updateBinaryStream(x$1, x$2, x$3)
  def updateBinaryStream(x$1: Int,x$2: InputStream,x$3: Long): Unit = inner.updateBinaryStream(x$1, x$2, x$3)
  def updateBinaryStream(x$1: String,x$2: InputStream,x$3: Int): Unit = inner.updateBinaryStream(x$1, x$2, x$3)
  def updateBinaryStream(x$1: Int,x$2: InputStream,x$3: Int): Unit = inner.updateBinaryStream(x$1, x$2, x$3)
  def updateBlob(x$1: String,x$2: InputStream): Unit = inner.updateBlob(x$1, x$2)
  def updateBlob(x$1: Int,x$2: InputStream): Unit = inner.updateBlob(x$1, x$2)
  def updateBlob(x$1: String,x$2: InputStream,x$3: Long): Unit = inner.updateBlob(x$1, x$2, x$3)
  def updateBlob(x$1: Int,x$2: InputStream,x$3: Long): Unit = inner.updateBlob(x$1, x$2, x$3)
  def updateBlob(x$1: String,x$2: java.sql.Blob): Unit = inner.updateBlob(x$1, x$2)
  def updateBlob(x$1: Int,x$2: java.sql.Blob): Unit = inner.updateBlob(x$1, x$2)
  def updateBoolean(x$1: String,x$2: Boolean): Unit = inner.updateBoolean(x$1, x$2)
  def updateBoolean(x$1: Int,x$2: Boolean): Unit = inner.updateBoolean(x$1, x$2)
  def updateByte(x$1: String,x$2: Byte): Unit = inner.updateByte(x$1, x$2)
  def updateByte(x$1: Int,x$2: Byte): Unit = inner.updateByte(x$1, x$2)
  def updateBytes(x$1: String,x$2: Array[Byte]): Unit = inner.updateBytes(x$1, x$2)
  def updateBytes(x$1: Int,x$2: Array[Byte]): Unit = inner.updateBytes(x$1, x$2)
  def updateCharacterStream(x$1: String,x$2: java.io.Reader): Unit = inner.updateCharacterStream(x$1, x$2)
  def updateCharacterStream(x$1: Int,x$2: java.io.Reader): Unit = inner.updateCharacterStream(x$1, x$2)
  def updateCharacterStream(x$1: String,x$2: java.io.Reader,x$3: Long): Unit = inner.updateCharacterStream(x$1, x$2, x$3)
  def updateCharacterStream(x$1: Int,x$2: java.io.Reader,x$3: Long): Unit = inner.updateCharacterStream(x$1, x$2, x$3)
  def updateCharacterStream(x$1: String,x$2: java.io.Reader,x$3: Int): Unit = inner.updateCharacterStream(x$1, x$2, x$3)
  def updateCharacterStream(x$1: Int,x$2: java.io.Reader,x$3: Int): Unit = inner.updateCharacterStream(x$1, x$2, x$3)
  def updateClob(x$1: String,x$2: java.io.Reader): Unit = inner.updateClob(x$1, x$2)
  def updateClob(x$1: Int,x$2: java.io.Reader): Unit = inner.updateClob(x$1, x$2)
  def updateClob(x$1: String,x$2: java.io.Reader,x$3: Long): Unit = inner.updateClob(x$1, x$2, x$3)
  def updateClob(x$1: Int,x$2: java.io.Reader,x$3: Long): Unit = inner.updateClob(x$1, x$2, x$3)
  def updateClob(x$1: String,x$2: java.sql.Clob): Unit = inner.updateClob(x$1, x$2)
  def updateClob(x$1: Int,x$2: java.sql.Clob): Unit = inner.updateClob(x$1, x$2)
  def updateDate(x$1: String,x$2: java.sql.Date): Unit = inner.updateDate(x$1, x$2)
  def updateDate(x$1: Int,x$2: java.sql.Date): Unit = inner.updateDate(x$1, x$2)
  def updateDouble(x$1: String,x$2: Double): Unit = inner.updateDouble(x$1, x$2)
  def updateDouble(x$1: Int,x$2: Double): Unit = inner.updateDouble(x$1, x$2)
  def updateFloat(x$1: String,x$2: Float): Unit = inner.updateFloat(x$1, x$2)
  def updateFloat(x$1: Int,x$2: Float): Unit = inner.updateFloat(x$1, x$2)
  def updateInt(x$1: String,x$2: Int): Unit = inner.updateInt(x$1, x$2)
  def updateInt(x$1: Int,x$2: Int): Unit = inner.updateInt(x$1, x$2)
  def updateLong(x$1: String,x$2: Long): Unit = inner.updateLong(x$1, x$2)
  def updateLong(x$1: Int,x$2: Long): Unit = inner.updateLong(x$1, x$2)
  def updateNCharacterStream(x$1: String,x$2: java.io.Reader): Unit = inner.updateNCharacterStream(x$1, x$2)
  def updateNCharacterStream(x$1: Int,x$2: java.io.Reader): Unit = inner.updateNCharacterStream(x$1, x$2)
  def updateNCharacterStream(x$1: String,x$2: java.io.Reader,x$3: Long): Unit = inner.updateNCharacterStream(x$1, x$2, x$3)
  def updateNCharacterStream(x$1: Int,x$2: java.io.Reader,x$3: Long): Unit = inner.updateNCharacterStream(x$1, x$2, x$3)
  def updateNClob(x$1: String,x$2: java.io.Reader): Unit = inner.updateNClob(x$1, x$2)
  def updateNClob(x$1: Int,x$2: java.io.Reader): Unit = inner.updateNClob(x$1, x$2)
  def updateNClob(x$1: String,x$2: java.io.Reader,x$3: Long): Unit = inner.updateNClob(x$1, x$2, x$3)
  def updateNClob(x$1: Int,x$2: java.io.Reader,x$3: Long): Unit = inner.updateNClob(x$1, x$2, x$3)
  def updateNClob(x$1: String,x$2: java.sql.NClob): Unit = inner.updateNClob(x$1, x$2)
  def updateNClob(x$1: Int,x$2: java.sql.NClob): Unit = inner.updateNClob(x$1, x$2)
  def updateNString(x$1: String,x$2: String): Unit = inner.updateNString(x$1, x$2)
  def updateNString(x$1: Int,x$2: String): Unit = inner.updateNString(x$1, x$2)
  def updateNull(x$1: String): Unit = inner.updateNull(x$1)
  def updateNull(x$1: Int): Unit = inner.updateNull(x$1)
  def updateObject(x$1: String,x$2: Any): Unit = inner.updateObject(x$1, x$2)
  def updateObject(x$1: String,x$2: Any,x$3: Int): Unit = inner.updateObject(x$1, x$2, x$3)
  def updateObject(x$1: Int,x$2: Any): Unit = inner.updateObject(x$1, x$2)
  def updateObject(x$1: Int,x$2: Any,x$3: Int): Unit = inner.updateObject(x$1, x$2, x$3)
  def updateRef(x$1: String,x$2: java.sql.Ref): Unit = inner.updateRef(x$1, x$2)
  def updateRef(x$1: Int,x$2: java.sql.Ref): Unit = inner.updateRef(x$1, x$2)
  def updateRow(): Unit = inner.updateRow()
  def updateRowId(x$1: String,x$2: java.sql.RowId): Unit = inner.updateRowId(x$1, x$2)
  def updateRowId(x$1: Int,x$2: java.sql.RowId): Unit = inner.updateRowId(x$1, x$2)
  def updateSQLXML(x$1: String,x$2: java.sql.SQLXML): Unit = inner.updateSQLXML(x$1, x$2)
  def updateSQLXML(x$1: Int,x$2: java.sql.SQLXML): Unit = inner.updateSQLXML(x$1, x$2)
  def updateShort(x$1: String,x$2: Short): Unit = inner.updateShort(x$1, x$2)
  def updateShort(x$1: Int,x$2: Short): Unit = inner.updateShort(x$1, x$2)
  def updateString(x$1: String,x$2: String): Unit = inner.updateString(x$1, x$2)
  def updateString(x$1: Int,x$2: String): Unit = inner.updateString(x$1, x$2)
  def updateTime(x$1: String,x$2: java.sql.Time): Unit = inner.updateTime(x$1, x$2)
  def updateTime(x$1: Int,x$2: java.sql.Time): Unit = inner.updateTime(x$1, x$2)
  def updateTimestamp(x$1: String,x$2: java.sql.Timestamp): Unit = inner.updateTimestamp(x$1, x$2)
  def updateTimestamp(x$1: Int,x$2: java.sql.Timestamp): Unit = inner.updateTimestamp(x$1, x$2)
  def wasNull(): Boolean = inner.wasNull()
}
