/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.banner.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.banner.model.BannerTypology;
import org.giavacms.banner.repository.BannerTypologyRepository;
import org.giavacms.common.model.Search;
import org.jboss.logging.Logger;

@SessionScoped
@Named
public class BannerProducer
implements Serializable {
    Logger logger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Inject
    private BannerTypologyRepository bannerTypologyRepository;
    private Map<Class, SelectItem[]> items = null;

    @Produces
    @Named
    public SelectItem[] getBannerTypologyItems() {
        if (this.items.get(BannerTypology.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona tipologia..."));
            for (BannerTypology t : this.bannerTypologyRepository.getList(new Search(BannerTypology.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getName() + " - " + t.getName()));
            }
            this.items.put(BannerTypology.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(BannerTypology.class);
    }

    public void resetItemsForClass(Class clazz) {
        if (this.items.containsKey(clazz)) {
            this.items.remove(clazz);
        }
    }

    @PostConstruct
    public void reset() {
        this.items = new HashMap<Class, SelectItem[]>();
    }
}

