/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl;

import com.sun.enterprise.config.serverbeans.AmxPref;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.MBeanTracker;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.base.SystemInfo;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.mbean.ComplianceMonitor;
import org.glassfish.admin.amx.impl.mbean.DomainRootImpl;
import org.glassfish.admin.amx.impl.mbean.SystemInfoFactory;
import org.glassfish.admin.amx.impl.mbean.SystemInfoImpl;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.TimingDelta;
import org.glassfish.admin.amx.util.jmx.stringifier.StringifierRegistryIniter;
import org.glassfish.admin.amx.util.stringifier.StringifierRegistryImpl;
import org.glassfish.admin.amx.util.stringifier.StringifierRegistryIniterImpl;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.api.amx.AMXLoader;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.AMXUtil;
import org.glassfish.external.amx.MBeanListener;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public final class AMXStartupService
implements PostConstruct,
PreDestroy,
AMXStartupServiceMBean {
    @Inject
    Habitat mHabitat;
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    Events mEvents;
    private volatile MBeanTracker mMBeanTracker;
    private volatile ObjectName DOMAIN_ROOT_OBJECTNAME = null;

    private static void debug(String s) {
        System.out.println(s);
    }

    public static MBeanTrackerMBean getMBeanTracker(MBeanServer server) {
        return MBeanServerInvocationHandler.newProxyInstance(server, MBeanTrackerMBean.MBEAN_TRACKER_OBJECT_NAME, MBeanTrackerMBean.class, false);
    }

    public AMXStartupService() {
        new StringifierRegistryIniterImpl(StringifierRegistryImpl.DEFAULT);
        new StringifierRegistryIniter(StringifierRegistryImpl.DEFAULT);
    }

    private void shutdown() {
        ImplUtil.getLogger().fine("AMXStartupService: shutting down AMX MBeans");
        this.unloadAMXMBeans();
        ObjectName allAMXPattern = AMXUtil.newObjectName((String)AMXGlassfish.DEFAULT.amxJMXDomain(), (String)"*");
        Set<ObjectName> remainingAMX = this.mMBeanServer.queryNames(allAMXPattern, null);
        if (remainingAMX.size() != 0) {
            ImplUtil.getLogger().log(Level.WARNING, "AMXStartupService.shutdown: MBeans have not been unregistered: " + remainingAMX);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        FeatureAvailability.getInstance().deRegisterFeatures();
        ImplUtil.getLogger().info("AMXStartupService: has been shut down and all AMX MBeans unregistered, remaining MBeans: " + this.mMBeanServer.queryNames(allAMXPattern, null));
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        SingletonEnforcer.register(this.getClass(), this);
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        try {
            StandardMBean mbean = new StandardMBean(this, AMXStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
            this.mMBeanTracker = new MBeanTracker(AMXGlassfish.DEFAULT.amxJMXDomain());
            AmxPref amxPref = InjectedValues.getInstance().getAMXPrefs();
            this.mMBeanTracker.setEmitMBeanStatus(amxPref == null ? false : Boolean.valueOf(amxPref.getEmitRegisrationStatus()));
            this.mMBeanServer.registerMBean(this.mMBeanTracker, MBeanTrackerMBean.MBEAN_TRACKER_OBJECT_NAME);
        }
        catch (Exception e) {
            ImplUtil.getLogger().log(Level.INFO, "Fatal error loading AMX", e);
            throw new Error(e);
        }
        ImplUtil.getLogger().info("Initialized AMXStartupServiceNew in " + delta.elapsedMillis() + " ms, registered as " + OBJECT_NAME);
        this.mEvents.register((EventListener)new ShutdownListener());
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("AMXStartupService.preDestroy(): stopping AMX");
        this.unloadAMXMBeans();
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        try {
            return (JMXServiceURL[])this.mMBeanServer.getAttribute(AMXGlassfish.DEFAULT.getBootAMXMBeanObjectName(), "JMXServiceURLs");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public static AMXStartupServiceMBean getAMXStartupServiceMBeanProxy(MBeanServer mbs) {
        AMXStartupServiceMBean ss = null;
        if (mbs.isRegistered(OBJECT_NAME)) {
            ss = (AMXStartupServiceMBean)AMXStartupServiceMBean.class.cast(MBeanServerInvocationHandler.newProxyInstance(mbs, OBJECT_NAME, AMXStartupServiceMBean.class, false));
        }
        return ss;
    }

    public synchronized ObjectName getDomainRoot() {
        try {
            return this.getDomainRootProxy().extra().objectName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRootProxy(false);
    }

    public ObjectName loadAMXMBeans() {
        ObjectName objectName = AMXGlassfish.DEFAULT.domainRoot();
        if (!this.mMBeanServer.isRegistered(objectName)) {
            try {
                objectName = this._loadAMXMBeans();
            }
            catch (Exception e) {
                AMXStartupService.debug("AMXStartupServiceNew.loadAMXMBeans: " + e);
                throw new RuntimeException(e);
            }
        }
        return objectName;
    }

    private synchronized ObjectName loadDomainRoot() {
        if (this.DOMAIN_ROOT_OBJECTNAME != null) {
            return this.DOMAIN_ROOT_OBJECTNAME;
        }
        DomainRootImpl domainRoot = new DomainRootImpl();
        this.DOMAIN_ROOT_OBJECTNAME = AMXGlassfish.DEFAULT.domainRoot();
        try {
            this.DOMAIN_ROOT_OBJECTNAME = this.mMBeanServer.registerMBean(domainRoot, this.DOMAIN_ROOT_OBJECTNAME).getObjectName();
            this.loadSystemInfo();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            ImplUtil.getLogger().log(Level.INFO, "Fatal error loading AMX DomainRoot", rootCause);
            throw new RuntimeException(rootCause);
        }
        return this.DOMAIN_ROOT_OBJECTNAME;
    }

    protected final ObjectName loadSystemInfo() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        SystemInfoImpl systemInfo = SystemInfoFactory.createInstance(this.mMBeanServer);
        ObjectName systemInfoObjectName = ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.DOMAIN_ROOT_OBJECTNAME, SystemInfo.class);
        systemInfoObjectName = this.mMBeanServer.registerMBean(systemInfo, systemInfoObjectName).getObjectName();
        return systemInfoObjectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName _loadAMXMBeans() {
        AMXGlassfish amxg = AMXGlassfish.DEFAULT;
        MBeanListener bootAMXListener = amxg.listenForBootAMX((MBeanServerConnection)this.mMBeanServer, (MBeanListener.Callback)new MyListener());
        MBeanListener domainRootListener = amxg.listenForDomainRoot((MBeanServerConnection)this.mMBeanServer, (MBeanListener.Callback)new MyListener());
        this.loadDomainRoot();
        FeatureAvailability.getInstance().registerFeature("AMXCoreReady", (Object)this.getDomainRoot());
        ImplUtil.getLogger().fine("AMXStartupServiceNew: AMX core MBeans are ready for use, DomainRoot = " + this.getDomainRoot());
        try {
            Collection loaders = this.mHabitat.getAllByContract(AMXLoader.class);
            ImplUtil.getLogger().fine("AMXStartupService._loadAMXMBeans(): found this many loaders: " + loaders.size());
            AMXLoaderThread[] threads = new AMXLoaderThread[loaders.size()];
            int i = 0;
            for (AMXLoader loader : loaders) {
                ImplUtil.getLogger().fine("AMXStartupService._loadAMXMBeans(): found this many loaders: " + loader);
                threads[i] = new AMXLoaderThread(loader);
                threads[i].start();
                ++i;
            }
            for (AMXLoaderThread thread : threads) {
                thread.waitDone();
            }
        }
        catch (Throwable t) {
            ImplUtil.getLogger().log(Level.INFO, "_loadAMXMBeans", t);
        }
        finally {
            FeatureAvailability.getInstance().registerFeature("AMXReady", (Object)this.getDomainRoot());
            ImplUtil.getLogger().info("AMXStartupServiceNew: AMX ready for use, DomainRoot = " + this.getDomainRoot());
        }
        if (((MyListener)bootAMXListener.getCallback()).getRegistered() == null) {
            throw new IllegalStateException("BootAMX listener was not called");
        }
        if (((MyListener)domainRootListener.getCallback()).getRegistered() == null) {
            throw new IllegalStateException("DomainRoot listener was not called");
        }
        return this.getDomainRoot();
    }

    public synchronized void unloadAMXMBeans() {
        if (this.getDomainRoot() != null) {
            Collection loaders = this.mHabitat.getAllByContract(AMXLoader.class);
            for (AMXLoader loader : loaders) {
                if (loader == this) continue;
                try {
                    loader.unloadAMXMBeans();
                }
                catch (Exception e) {
                    ImplUtil.getLogger().info("AMXLoader failed to unload: " + e);
                }
            }
            ImplUtil.unregisterAMXMBeans((AMXProxy)this.getDomainRootProxy());
            this.DOMAIN_ROOT_OBJECTNAME = null;
            ComplianceMonitor.removeInstance();
            SystemInfoFactory.removeInstance();
        }
    }

    class MyListener
    extends MBeanListener.CallbackImpl {
        MyListener() {
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
        }
    }

    private static final class AMXLoaderThread
    extends Thread {
        private final AMXLoader mLoader;
        private volatile ObjectName mTop;
        private final CountDownLatch mLatch;

        public AMXLoaderThread(AMXLoader loader) {
            this.mLoader = loader;
            this.mLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ImplUtil.getLogger().fine("AMXStartupServiceNew.AMXLoaderThread: loading: " + this.mLoader.getClass().getName());
                this.mTop = this.mLoader.loadAMXMBeans();
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.INFO, "AMXStartupServiceNew._loadAMXMBeans: AMXLoader failed to load", e);
            }
            finally {
                this.mLatch.countDown();
            }
        }

        public ObjectName waitDone() {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTop;
        }

        public ObjectName top() {
            return this.mTop;
        }
    }

    private final class ShutdownListener
    implements EventListener {
        private ShutdownListener() {
        }

        public void event(EventListener.Event event) {
            if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                AMXStartupService.this.shutdown();
            }
        }
    }
}

