/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectNameBuilder {
    private final MBeanServer mMBeanServer;
    private final String mJMXDomain;
    private final ObjectName mParent;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public ObjectNameBuilder(MBeanServer mbeanServer, String jmxDomain) {
        this.mMBeanServer = mbeanServer;
        this.mJMXDomain = jmxDomain;
        this.mParent = null;
    }

    public ObjectNameBuilder(MBeanServer mbeanServer, ObjectName parent) {
        this.mMBeanServer = mbeanServer;
        if (parent == null) {
            throw new IllegalArgumentException("null ObjecName for parent");
        }
        this.mParent = parent;
        this.mJMXDomain = parent.getDomain();
    }

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    public String getJMXDomain() {
        return this.mJMXDomain;
    }

    private ObjectName newObjectName(String props) {
        return Util.newObjectName((String)this.getJMXDomain(), (String)props);
    }

    public static String makeWild(String props) {
        return Util.concatenateProps((String)props, (String)",*");
    }

    public static List<ObjectName> getAncestors(MBeanServer server, ObjectName start) {
        AMXProxy amx = ProxyFactory.getInstance((MBeanServer)server).getProxy(start, AMXProxy.class);
        ArrayList<ObjectName> ancestors = new ArrayList<ObjectName>();
        AMXProxy parent = null;
        while ((parent = amx.parent()) != null) {
            ancestors.add(parent.extra().objectName());
            amx = parent;
        }
        Collections.reverse(ancestors);
        ancestors.add(start);
        return ancestors;
    }

    public ObjectName buildChildObjectName(ObjectName parent, String type, String childName) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, parent, type, childName);
    }

    public ObjectName buildChildObjectName(String type, String childName) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.mParent, type, childName);
    }

    public ObjectName buildChildObjectName(Class<?> intf) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.mParent, intf);
    }

    public ObjectName buildChildObjectName(Class<?> intf, String name) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.mParent, intf, name);
    }

    public static ObjectName buildChildObjectName(MBeanServer server, ObjectName parent, String type, String childName) {
        String props = Util.makeRequiredProps((String)type, (String)childName);
        AMXProxy parentProxy = ProxyFactory.getInstance((MBeanServer)server).getProxy(parent, AMXProxy.class);
        String parentPath = parentProxy.path();
        String parentPathProp = Util.makeProp((String)"pp", (String)Util.quoteIfNeeded((String)parentPath));
        props = Util.concatenateProps((String)parentPathProp, (String)props);
        return JMXUtil.newObjectName((String)parent.getDomain(), (String)props);
    }

    public static ObjectName buildChildObjectName(MBeanServer server, ObjectName parent, Class<?> intf, String name) {
        String type = Util.deduceType(intf);
        return ObjectNameBuilder.buildChildObjectName(server, parent, type, name);
    }

    public static ObjectName buildChildObjectName(MBeanServer server, ObjectName parent, Class<?> intf) {
        return ObjectNameBuilder.buildChildObjectName(server, parent, intf, null);
    }

    private static String toString(Object o) {
        return SmartStringifier.toString((Object)o);
    }
}

