/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.info;

public abstract class JVMInfo {
    public static final int JDK_ID;
    public static final int J2SE_13 = 2;
    public static final int J2SE_14 = 4;
    public static final int J2SE_142 = 5;
    public static final int J2SE_15 = 6;
    public static final int J2SE_16 = 7;
    public static final boolean J2ME;
    public static final int JAVA_SQL_TYPES_BOOLEAN;

    private static boolean vmCheck(String string, String string2) {
        return string.equals(string2) || string.startsWith(string2 + "_");
    }

    public static String derbyVMLevel() {
        switch (JDK_ID) {
            case 2: {
                return J2ME ? "J2ME - JDBC for CDC/FP 1.0" : "J2SE 1.3 - JDBC 2.1";
            }
            case 4: {
                return "J2SE 1.4 - JDBC 3.0";
            }
            case 5: {
                return "J2SE 1.4.2 - JDBC 3.0";
            }
            case 6: {
                return "J2SE 5.0 - JDBC 3.0";
            }
            case 7: {
                return "Java SE 6 - JDBC 4.0";
            }
        }
        return "?-?";
    }

    static {
        boolean bl;
        int n;
        String string;
        String string2;
        try {
            string2 = System.getProperty("java.specification.name");
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        try {
            string = System.getProperty("java.specification.version", "1.3");
        }
        catch (SecurityException securityException) {
            string = "1.3";
        }
        if (string2 != null && string2.startsWith("J2ME")) {
            n = 2;
            bl = true;
        } else {
            bl = false;
            if (string.equals("1.2") || string.equals("1.3")) {
                n = 2;
            } else if (string.equals("1.4")) {
                String string3 = System.getProperty("java.version", "1.4.0");
                n = JVMInfo.vmCheck(string3, "1.4.0") || JVMInfo.vmCheck(string3, "1.4.1") ? 4 : 5;
            } else if (string.equals("1.5")) {
                n = 6;
            } else if (string.equals("1.6")) {
                n = 7;
            } else {
                n = 2;
                try {
                    if (Float.valueOf(string).floatValue() > 1.6f) {
                        n = 7;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        JDK_ID = n;
        J2ME = bl;
        JAVA_SQL_TYPES_BOOLEAN = bl || n >= 4 ? 16 : -7;
    }
}

