/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public abstract class HttpHeader
extends HttpPacket
implements MimeHeadersPacket,
AttributeStorage {
    protected boolean isCommitted;
    protected final MimeHeaders headers = new MimeHeaders();
    protected final DataChunk protocolC = DataChunk.newInstance();
    protected Protocol parsedProtocol;
    protected boolean isChunked;
    private final Buffer tmpContentLengthBuffer = Buffers.wrap(MemoryManager.DEFAULT_MEMORY_MANAGER, new byte[20]);
    protected long contentLength = -1L;
    protected String characterEncoding;
    protected String quotedCharsetValue;
    protected boolean charsetSet = false;
    private boolean charEncodingParsed = false;
    private String defaultContentType;
    protected boolean contentTypeParsed;
    protected String contentType;
    protected boolean isExpectContent = true;
    protected boolean isSkipRemainder;
    protected boolean isContentBroken;
    protected boolean secure;
    protected final DataChunk upgrade = DataChunk.newInstance();
    private TransferEncoding transferEncoding;
    private final List<ContentEncoding> contentEncodings = new ArrayList<ContentEncoding>();
    private boolean isContentEncodingsSelected;
    private final AttributeHolder attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);
    Buffer headerBuffer;

    void setHeaderBuffer(Buffer headerBuffer) {
        this.headerBuffer = headerBuffer;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public abstract boolean isRequest();

    @Override
    public final boolean isHeader() {
        return true;
    }

    public abstract ProcessingState getProcessingState();

    protected void addContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncodings.add(contentEncoding);
    }

    protected List<ContentEncoding> getContentEncodings(boolean isModifiable) {
        if (isModifiable) {
            return this.contentEncodings;
        }
        return Collections.unmodifiableList(this.contentEncodings);
    }

    public List<ContentEncoding> getContentEncodings() {
        return this.getContentEncodings(false);
    }

    protected final boolean isContentEncodingsSelected() {
        return this.isContentEncodingsSelected;
    }

    protected final void setContentEncodingsSelected(boolean isContentEncodingsSelected) {
        this.isContentEncodingsSelected = isContentEncodingsSelected;
    }

    public TransferEncoding getTransferEncoding() {
        return this.transferEncoding;
    }

    protected void setTransferEncoding(TransferEncoding transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean isChunked) {
        this.isChunked = isChunked;
    }

    public boolean isExpectContent() {
        return this.isExpectContent;
    }

    protected void setExpectContent(boolean isExpectContent) {
        this.isExpectContent = isExpectContent;
    }

    public boolean isSkipRemainder() {
        return this.isSkipRemainder;
    }

    public void setSkipRemainder(boolean isSkipRemainder) {
        this.isSkipRemainder = isSkipRemainder;
    }

    public boolean isContentBroken() {
        return this.isContentBroken;
    }

    public void setContentBroken(boolean isBroken) {
        this.isContentBroken = isBroken;
    }

    public String getUpgrade() {
        if (!this.upgrade.isNull()) {
            return this.upgrade.toString();
        }
        String upgradeStr = this.headers.getHeader(Header.Upgrade);
        if (upgradeStr != null) {
            this.upgrade.setString(upgradeStr);
        }
        return upgradeStr;
    }

    public DataChunk getUpgradeDC() {
        return this.upgrade;
    }

    public void setUpgrade(String upgrade) {
        this.upgrade.setString(upgrade);
    }

    protected void makeUpgradeHeader() {
        if (!this.upgrade.isNull()) {
            this.headers.setValue(Header.Upgrade).set(this.upgrade);
        }
    }

    protected void makeContentLengthHeader(long defaultLength) {
        if (this.contentLength != -1L) {
            HttpUtils.longToBuffer(this.contentLength, this.tmpContentLengthBuffer.clear());
            this.headers.setValue(Header.ContentLength).setBuffer(this.tmpContentLengthBuffer, this.tmpContentLengthBuffer.position(), this.tmpContentLengthBuffer.limit());
        } else if (defaultLength != -1L) {
            HttpUtils.longToBuffer(defaultLength, this.tmpContentLengthBuffer.clear());
            int idx = this.headers.indexOf(Header.ContentLength, 0);
            if (idx == -1) {
                this.headers.addValue(Header.ContentLength).setBuffer(this.tmpContentLengthBuffer, this.tmpContentLengthBuffer.position(), this.tmpContentLengthBuffer.limit());
            } else if (this.headers.getValue(idx).isNull()) {
                this.headers.getValue(idx).setBuffer(this.tmpContentLengthBuffer, this.tmpContentLengthBuffer.position(), this.tmpContentLengthBuffer.limit());
            }
        }
    }

    public long getContentLength() {
        DataChunk contentLengthChunk;
        if (this.contentLength == -1L && (contentLengthChunk = this.headers.getValue(Header.ContentLength)) != null) {
            this.contentLength = Ascii.parseLong(contentLengthChunk);
        }
        return this.contentLength;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        if (len < 0) {
            this.headers.removeHeader(Header.ContentLength);
        }
    }

    public void setContentLengthLong(long contentLength) {
        this.contentLength = contentLength;
        if (contentLength < 0L) {
            this.headers.removeHeader(Header.ContentLength);
        }
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    protected void makeTransferEncodingHeader(String defaultValue) {
        int idx = this.headers.indexOf(Header.TransferEncoding, 0);
        if (idx == -1) {
            this.headers.addValue(Header.TransferEncoding).setString("chunked");
        }
    }

    protected void extractContentEncoding(DataChunk value) {
        int idx = this.headers.indexOf(Header.ContentEncoding, 0);
        if (idx != -1) {
            this.headers.getAndSetSerialized(idx, true);
            value.set(this.headers.getValue(idx));
        }
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null || this.charEncodingParsed) {
            return this.characterEncoding;
        }
        if (this.isContentTypeSet()) {
            this.getContentType();
            this.charEncodingParsed = true;
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    protected final Buffer serializeContentType(MemoryManager memoryManager, Buffer buffer) {
        DataChunk value;
        int idx = this.headers.indexOf(Header.ContentType, 0);
        if (idx != -1 && !(value = this.headers.getValue(idx)).isNull()) {
            if (this.contentType == null) {
                this.contentType = value.toString();
            }
            this.headers.getAndSetSerialized(idx, true);
        }
        if (this.contentType != null) {
            buffer = HttpCodecUtils.put(memoryManager, buffer, Header.ContentType.getBytes());
            buffer = HttpCodecUtils.put(memoryManager, buffer, HttpCodecFilter.COLON_BYTES);
            buffer = HttpCodecUtils.put(memoryManager, buffer, this.contentType);
            if (this.quotedCharsetValue != null && this.charsetSet) {
                buffer = HttpCodecUtils.put(memoryManager, buffer, ";charset=");
                buffer = HttpCodecUtils.put(memoryManager, buffer, this.quotedCharsetValue);
            }
            buffer = HttpCodecUtils.put(memoryManager, buffer, HttpCodecFilter.CRLF_BYTES);
        } else {
            String defaultType = this.getDefaultContentType();
            if (defaultType != null) {
                buffer = HttpCodecUtils.put(memoryManager, buffer, Header.ContentType.getBytes());
                buffer = HttpCodecUtils.put(memoryManager, buffer, HttpCodecFilter.COLON_BYTES);
                buffer = HttpCodecUtils.put(memoryManager, buffer, defaultType);
                buffer = HttpCodecUtils.put(memoryManager, buffer, HttpCodecFilter.CRLF_BYTES);
            }
        }
        return buffer;
    }

    public boolean isContentTypeSet() {
        return this.contentType != null || this.characterEncoding != null || this.headers.getValue(Header.ContentType) != null;
    }

    public String getContentType() {
        String ret;
        if (!this.contentTypeParsed) {
            DataChunk dc;
            this.contentTypeParsed = true;
            if (this.contentType == null && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
                this.setContentType(dc.toString());
            }
        }
        if ((ret = this.contentType) != null && this.quotedCharsetValue != null && this.charsetSet) {
            ret = ret + ";charset=" + this.quotedCharsetValue;
        }
        return ret;
    }

    public void setContentType(String type) {
        String charsetValue;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int semicolonIndex = -1;
        int index = type.indexOf(59);
        while (index != -1) {
            int len = type.length();
            semicolonIndex = index++;
            while (index < len && type.charAt(index) == ' ') {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        return this.headers.getHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.setValue(name).setString(value);
    }

    @Override
    public void setHeader(Header header, String value) {
        this.headers.setValue(header).setString(value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.addValue(name).setString(value);
    }

    @Override
    public void addHeader(Header header, String value) {
        this.headers.addValue(header).setString(value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    @Override
    public boolean containsHeader(Header header) {
        return this.headers.getHeader(header) != null;
    }

    public DataChunk getProtocolDC() {
        this.parsedProtocol = null;
        return this.protocolC;
    }

    public String getProtocolString() {
        if (this.parsedProtocol == null) {
            return this.getProtocolDC().toString();
        }
        return this.parsedProtocol.getProtocolString();
    }

    public Protocol getProtocol() {
        if (this.parsedProtocol != null) {
            return this.parsedProtocol;
        }
        this.parsedProtocol = Protocol.parseDataChunk(this.protocolC);
        return this.parsedProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.parsedProtocol = protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public final HttpContent.Builder httpContentBuilder() {
        return HttpContent.builder(this);
    }

    public HttpTrailer.Builder httpTrailerBuilder() {
        return HttpTrailer.builder(this);
    }

    protected void reset() {
        this.isContentEncodingsSelected = false;
        this.secure = false;
        this.isSkipRemainder = false;
        this.isContentBroken = false;
        this.attributes.recycle();
        this.protocolC.recycle();
        this.parsedProtocol = null;
        this.contentEncodings.clear();
        this.headers.clear();
        this.isCommitted = false;
        this.isChunked = false;
        this.contentLength = -1L;
        this.characterEncoding = null;
        this.defaultContentType = null;
        this.quotedCharsetValue = null;
        this.charsetSet = false;
        this.charEncodingParsed = false;
        this.contentType = null;
        this.contentTypeParsed = false;
        this.transferEncoding = null;
        this.isExpectContent = true;
        this.upgrade.recycle();
        if (this.headerBuffer != null) {
            this.headerBuffer.dispose();
            this.headerBuffer = null;
        }
    }

    @Override
    public void recycle() {
        this.reset();
    }

    protected String getDefaultContentType() {
        return this.defaultContentType;
    }

    protected void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public static abstract class Builder<T extends Builder> {
        protected HttpHeader packet;

        public final T protocol(Protocol protocol) {
            this.packet.setProtocol(protocol);
            return (T)this;
        }

        public final T protocol(String protocol) {
            this.packet.getProtocolDC().setString(protocol);
            return (T)this;
        }

        public final T chunked(boolean isChunked) {
            this.packet.setChunked(isChunked);
            return (T)this;
        }

        public final T contentLength(long contentLength) {
            this.packet.setContentLengthLong(contentLength);
            return (T)this;
        }

        public final T contentType(String contentType) {
            this.packet.setContentType(contentType);
            return (T)this;
        }

        public final T upgrade(String upgrade) {
            this.packet.setUpgrade(upgrade);
            return (T)this;
        }

        public final T header(String name, String value) {
            this.packet.addHeader(name, value);
            return (T)this;
        }

        public final T header(Header header, String value) {
            this.packet.addHeader(header, value);
            return (T)this;
        }
    }
}

