/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class DataFrame
extends SpdyFrame {
    private static final ThreadCache.CachedTypeIndex<DataFrame> CACHE_IDX = ThreadCache.obtainIndex(DataFrame.class, 8);
    public static final byte FLAG_FIN = 1;
    private Buffer data;
    private int streamId;

    private DataFrame() {
    }

    static DataFrame create() {
        DataFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new DataFrame();
        }
        return frame;
    }

    static DataFrame create(SpdyHeader header) {
        DataFrame frame = DataFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static DataFrameBuilder builder() {
        return new DataFrameBuilder();
    }

    public Buffer getData() {
        return this.data;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataFrame");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", data=").append(this.data);
        sb.append(", fin=").append(this.isFlagSet((byte)1));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.data = null;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Object headerBuffer = memoryManager.allocate(8);
        headerBuffer.putInt(this.streamId & Integer.MAX_VALUE);
        headerBuffer.putInt(this.flags << 24 | this.data.remaining());
        headerBuffer.trim();
        Buffer resultBuffer = Buffers.appendBuffers(memoryManager, headerBuffer, this.data);
        if (resultBuffer.isComposite()) {
            resultBuffer.allowBufferDispose(true);
            ((CompositeBuffer)resultBuffer).allowInternalBuffersDispose(true);
            ((CompositeBuffer)resultBuffer).disposeOrder(CompositeBuffer.DisposeOrder.FIRST_TO_LAST);
        }
        return resultBuffer;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.streamId = header.getStreamId();
        this.data = header.buffer;
    }

    public static class DataFrameBuilder
    extends SpdyFrame.SpdyFrameBuilder<DataFrameBuilder> {
        private DataFrame dataFrame;

        protected DataFrameBuilder() {
            super(DataFrame.create());
            this.dataFrame = (DataFrame)this.frame;
        }

        public DataFrameBuilder streamId(int streamId) {
            this.dataFrame.streamId = streamId;
            return this;
        }

        public DataFrameBuilder data(Buffer data) {
            this.dataFrame.data = data;
            return this;
        }

        public DataFrameBuilder last(boolean last) {
            if (last) {
                this.dataFrame.setFlag((byte)1);
            } else {
                this.dataFrame.clearFlag((byte)1);
            }
            return this;
        }

        public DataFrame build() {
            return this.dataFrame;
        }

        @Override
        protected DataFrameBuilder getThis() {
            return this;
        }
    }
}

