/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContentDisposition {
    protected final String disposition;
    private boolean isParamsParsed;
    protected String dispositionType;
    protected final Map<String, ParamValue> dispositionParams = new HashMap<String, ParamValue>();

    protected ContentDisposition(String disposition) {
        this.disposition = disposition;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getDispositionType() {
        if (!this.isParamsParsed) {
            this.isParamsParsed = true;
            this.parseParams();
        }
        return this.dispositionType;
    }

    public Set<String> getDispositionParams() {
        if (!this.isParamsParsed) {
            this.isParamsParsed = true;
            this.parseParams();
        }
        return this.dispositionParams.keySet();
    }

    public String getDispositionParam(String paramName) {
        if (!this.isParamsParsed) {
            this.isParamsParsed = true;
            this.parseParams();
        }
        return this.dispositionParams.get(paramName).get();
    }

    public String getDispositionParamUnquoted(String paramName) {
        if (!this.isParamsParsed) {
            this.isParamsParsed = true;
            this.parseParams();
        }
        return this.dispositionParams.get(paramName).getUnquoted();
    }

    public String toString() {
        return this.disposition;
    }

    public int hashCode() {
        return this.disposition.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentDisposition other = (ContentDisposition)obj;
        return !(this.disposition == null ? other.disposition != null : !this.disposition.equals(other.disposition));
    }

    private void parseParams() {
        int semicolon1 = this.disposition.indexOf(59);
        if (semicolon1 == -1) {
            this.dispositionType = this.disposition;
            return;
        }
        for (int i = semicolon1 + 1; i < this.disposition.length(); ++i) {
            int semicolonN;
            String value;
            boolean isQuot;
            int nameStart = this.skipSpaces(i);
            if (nameStart == -1) {
                return;
            }
            i = nameStart;
            int eq = this.skipTo('=', i);
            if (eq == -1) {
                throw new IllegalStateException("Can't locate '=' symbol");
            }
            String name = this.disposition.substring(nameStart, this.findLastNonSpace(eq - 1, nameStart) + 1);
            int valueStart = this.skipSpaces(eq + 1);
            if (valueStart == -1) {
                throw new IllegalStateException("Can't find parameter value");
            }
            char q = this.disposition.charAt(valueStart);
            boolean bl = isQuot = q == '\"' || q == '\'';
            if (isQuot) {
                int nextQuot = this.skipTo(q, valueStart + 1);
                if (nextQuot == -1) {
                    throw new IllegalStateException("Closing quot wasn't found");
                }
                value = this.disposition.substring(valueStart, nextQuot + 1);
                semicolonN = this.skipToSemicolon(nextQuot + 1);
            } else {
                semicolonN = this.skipToSemicolon(valueStart + 1);
                value = this.disposition.substring(valueStart, this.findLastNonSpace(semicolonN - 1, valueStart) + 1);
            }
            this.dispositionParams.put(name, new ParamValue(value));
            i = semicolonN + 1;
        }
    }

    private int skipSpaces(int offset) {
        while (offset < this.disposition.length()) {
            if (this.disposition.charAt(offset) >= '!') {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private int findLastNonSpace(int offset, int lowLim) {
        while (offset >= lowLim) {
            char c = this.disposition.charAt(offset);
            if (c > ' ') {
                return offset;
            }
            --offset;
        }
        return -1;
    }

    private int skipTo(char charToSkip, int offset) {
        while (offset < this.disposition.length()) {
            char c = this.disposition.charAt(offset);
            if (c == charToSkip) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private int skipToSemicolon(int offset) {
        while (offset < this.disposition.length()) {
            char c = this.disposition.charAt(offset);
            if (c == ';') {
                return offset;
            }
            ++offset;
        }
        return offset;
    }

    protected static final class ParamValue {
        private final String initial;
        private volatile String unquoted;

        public ParamValue(String initial) {
            this.initial = initial;
        }

        public String get() {
            return this.initial;
        }

        public String getUnquoted() {
            if (this.unquoted == null) {
                this.unquoted = ParamValue.isQuoted(this.initial) ? this.initial.substring(1, this.initial.length() - 1) : this.initial;
            }
            return this.unquoted;
        }

        private static boolean isQuoted(String initial) {
            int length = initial.length();
            if (length < 2) {
                return false;
            }
            char c = initial.charAt(0);
            return (c == '\'' || c == '\"') && c == initial.charAt(length - 1);
        }
    }
}

