/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.multipart.MultipartEntryHandler;
import org.glassfish.grizzly.http.multipart.MultipartReadHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.io.NIOInputStream;
import org.glassfish.grizzly.http.server.io.ReadHandler;

public class MultipartScanner {
    private static final Logger LOGGER = Grizzly.logger(MultipartScanner.class);
    static final String MULTIPART_CONTENT_TYPE = "multipart/form-data";
    static final String MULTIPART_MIXED_CONTENT_TYPE = "multipart/mixed";
    private static final String BOUNDARY_ATTR = "boundary";

    private MultipartScanner() {
    }

    public static void scan(Request request, MultipartEntryHandler partHandler, CompletionHandler<Request> completionHandler) {
        try {
            String contentType = request.getContentType();
            String[] contentTypeParams = contentType.split(";");
            if (contentTypeParams.length != 2 || !MULTIPART_CONTENT_TYPE.equals(contentTypeParams[0])) {
                throw new IllegalStateException("Not multipart request");
            }
            String boundaryString = contentTypeParams[1].trim();
            String[] boundaryNameValue = boundaryString.split("=");
            if (boundaryNameValue.length != 2 || !BOUNDARY_ATTR.equals(boundaryNameValue[0].trim())) {
                throw new IllegalStateException("Boundary not found");
            }
            String boundaryValue = boundaryNameValue[1].trim();
            if (boundaryValue.charAt(0) == '\"') {
                boundaryValue = boundaryValue.substring(1, boundaryValue.length() - 1);
            }
            NIOInputStream nioInputStream = request.getInputStream(false);
            nioInputStream.notifyAvailable((ReadHandler)new MultipartReadHandler(request, partHandler, completionHandler, boundaryValue));
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed((Throwable)e);
            }
            LOGGER.log(Level.WARNING, "Error occurred, but no CompletionHandler installed to handle it", e);
        }
    }

    public static void scan(MultipartEntry multipartMixedEntry, MultipartEntryHandler partHandler, CompletionHandler<MultipartEntry> completionHandler) {
        try {
            String contentType = multipartMixedEntry.getContentType();
            String[] contentTypeParams = contentType.split(";");
            if (contentTypeParams.length != 2 || !MULTIPART_MIXED_CONTENT_TYPE.equals(contentTypeParams[0])) {
                throw new IllegalStateException("Not multipart/mixed entry");
            }
            String boundaryString = contentTypeParams[1].trim();
            String[] boundaryNameValue = boundaryString.split("=");
            if (boundaryNameValue.length != 2 || !BOUNDARY_ATTR.equals(boundaryNameValue[0].trim())) {
                throw new IllegalStateException("Boundary not found");
            }
            String boundaryValue = boundaryNameValue[1].trim();
            if (boundaryValue.charAt(0) == '\"') {
                boundaryValue = boundaryValue.substring(1, boundaryValue.length() - 1);
            }
            NIOInputStream nioInputStream = multipartMixedEntry.getNIOInputStream();
            nioInputStream.notifyAvailable((ReadHandler)new MultipartReadHandler(multipartMixedEntry, partHandler, completionHandler, boundaryValue));
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed((Throwable)e);
            }
            LOGGER.log(Level.WARNING, "Error occurred, but no CompletionHandler installed to handle it", e);
        }
    }
}

