/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.server.io.NIOInputStream;
import org.glassfish.grizzly.http.server.io.NIOReader;
import org.glassfish.grizzly.http.server.io.ReadHandler;
import org.glassfish.grizzly.utils.Charsets;

final class MultipartEntryNIOReader
extends NIOReader {
    private boolean isClosed;
    private final MultipartEntry multipartEntry;
    private NIOInputStream requestNIOInputStream;
    private String encoding;
    private CharsetDecoder decoder;
    private float averageCharsPerByte;
    private final CharBuffer singleCharBuf = CharBuffer.allocate(1);
    private int requestedSize;
    private ReadHandler handler;

    public MultipartEntryNIOReader(MultipartEntry multipartEntry) {
        this.multipartEntry = multipartEntry;
    }

    protected void initialize(NIOInputStream requestInputStream, String encoding) {
        this.requestNIOInputStream = requestInputStream;
        this.encoding = encoding;
        this.averageCharsPerByte = this.getDecoder().averageCharsPerByte();
    }

    public int read(CharBuffer target) throws IOException {
        int count = this.fillChar(target.capacity(), target);
        target.flip();
        return count;
    }

    public int read() throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        this.singleCharBuf.position(0);
        int read = this.read(this.singleCharBuf);
        if (read == -1) {
            return -1;
        }
        char c = this.singleCharBuf.get(0);
        this.singleCharBuf.position(0);
        return c;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        if (len == 0) {
            return 0;
        }
        CharBuffer buf = CharBuffer.wrap(cbuf, off, len);
        return this.read(buf);
    }

    public long skip(long n) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        if (n > (long)this.multipartEntry.availableBytes()) {
            throw new IllegalStateException("Can not skip more bytes than available");
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        CharBuffer skipBuffer = CharBuffer.allocate((int)n);
        if (this.fillChar((int)n, skipBuffer) == -1) {
            return 0L;
        }
        return Math.min((long)skipBuffer.position(), n);
    }

    public boolean ready() throws IOException {
        return this.isReady();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException();
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public void notifyAvailable(ReadHandler handler) {
        this.notifyAvailable(handler, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAvailable(ReadHandler handler, int size) {
        if (this.isClosed || this.isFinished()) {
            try {
                handler.onAllDataRead();
            }
            catch (Exception ioe) {
                try {
                    handler.onError((Throwable)ioe);
                }
                finally {
                    try {
                        this.requestNIOInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            return;
        }
        if (MultipartEntryNIOReader.shouldNotifyNow(size, this.readyData())) {
            try {
                handler.onDataAvailable();
            }
            catch (Exception ioe) {
                try {
                    handler.onError((Throwable)ioe);
                }
                finally {
                    try {
                        this.requestNIOInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            return;
        }
        this.requestedSize = size;
        this.handler = handler;
    }

    public boolean isFinished() {
        return this.multipartEntry.isFinished();
    }

    public int readyData() {
        return (int)((float)this.multipartEntry.availableBytes() * this.averageCharsPerByte);
    }

    public boolean isReady() {
        return this.readyData() > 0;
    }

    protected void recycle() {
        this.requestNIOInputStream = null;
        this.decoder = null;
        this.averageCharsPerByte = 1.0f;
        this.encoding = null;
        this.handler = null;
        this.isClosed = false;
        this.requestedSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDataCame() {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.isFinished()) {
                this.handler.onAllDataRead();
            } else if (MultipartEntryNIOReader.shouldNotifyNow(this.requestedSize, this.readyData())) {
                this.handler.onDataAvailable();
            }
        }
        catch (Exception e) {
            try {
                this.handler.onError((Throwable)e);
            }
            finally {
                try {
                    this.requestNIOInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int fillChar(int requestedLen, CharBuffer dst) throws IOException {
        int charPos = dst.position();
        ByteBuffer bb = this.requestNIOInputStream.getBuffer().toByteBuffer();
        int bbPos = bb.position();
        int bbLim = bb.limit();
        bb.limit(bbPos + this.multipartEntry.availableBytes());
        this.getDecoder().decode(bb, dst, false);
        int readChars = dst.position() - charPos;
        int readBytes = bb.position() - bbPos;
        bb.position(bbPos);
        bb.limit(bbLim);
        this.requestNIOInputStream.skip((long)readBytes);
        this.multipartEntry.addAvailableBytes(-readBytes);
        if (this.multipartEntry.availableBytes() > 0 && readChars < requestedLen) {
            readChars += this.fillChar(0, dst);
        }
        return readChars;
    }

    private CharsetDecoder getDecoder() {
        if (this.decoder == null) {
            Charset cs = Charsets.lookupCharset((String)this.encoding);
            this.decoder = cs.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this.decoder;
    }

    private static boolean shouldNotifyNow(int size, int available) {
        return available != 0 && available >= size;
    }
}

