/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.multipart.MultipartContext;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.multipart.MultipartEntryHandler;
import org.glassfish.grizzly.http.multipart.MultipartReadHandler;
import org.glassfish.grizzly.http.server.Request;

public class MultipartScanner {
    public static final String BOUNDARY_ATTR = "boundary";
    private static final Logger LOGGER = Grizzly.logger(MultipartScanner.class);
    static final String MULTIPART_CONTENT_TYPE = "multipart";

    private MultipartScanner() {
    }

    public static void scan(Request request, MultipartEntryHandler partHandler, CompletionHandler<Request> completionHandler) {
        try {
            String contentType = request.getContentType();
            String[] contentTypeParams = contentType.split(";");
            String[] contentSubType = contentTypeParams[0].split("/");
            if (contentSubType.length != 2 || !MULTIPART_CONTENT_TYPE.equalsIgnoreCase(contentSubType[0])) {
                throw new IllegalStateException("Not multipart request");
            }
            String boundary = null;
            HashMap<String, String> contentTypeProperties = new HashMap<String, String>();
            for (int i = 1; i < contentTypeParams.length; ++i) {
                String param = contentTypeParams[i].trim();
                String[] paramValue = param.split("=", 2);
                if (paramValue.length != 2) continue;
                String key = paramValue[0].trim();
                String value = paramValue[1].trim();
                if (value.charAt(0) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                contentTypeProperties.put(key, value);
                if (!BOUNDARY_ATTR.equals(key)) continue;
                boundary = value;
            }
            if (boundary == null) {
                throw new IllegalStateException("Boundary not found");
            }
            NIOInputStream nioInputStream = request.getNIOInputStream();
            nioInputStream.notifyAvailable((ReadHandler)new MultipartReadHandler(request, partHandler, completionHandler, new MultipartContext(boundary, contentType, contentTypeProperties)));
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed((Throwable)e);
            }
            LOGGER.log(Level.WARNING, "Error occurred, but no CompletionHandler installed to handle it", e);
        }
    }

    public static void scan(MultipartEntry multipartMixedEntry, MultipartEntryHandler partHandler, CompletionHandler<MultipartEntry> completionHandler) {
        try {
            String contentType = multipartMixedEntry.getContentType();
            String[] contentTypeParams = contentType.split(";");
            String[] contentSubType = contentTypeParams[0].split("/");
            if (contentSubType.length != 2 || !MULTIPART_CONTENT_TYPE.equalsIgnoreCase(contentSubType[0])) {
                throw new IllegalStateException("Not multipart request");
            }
            String boundary = null;
            HashMap<String, String> contentTypeProperties = new HashMap<String, String>();
            for (int i = 1; i < contentTypeParams.length; ++i) {
                String param = contentTypeParams[i].trim();
                String[] paramValue = param.split("=", 2);
                if (paramValue.length != 2) continue;
                String key = paramValue[0].trim();
                String value = paramValue[1].trim();
                if (value.charAt(0) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                contentTypeProperties.put(key, value);
                if (!BOUNDARY_ATTR.equals(key)) continue;
                boundary = value;
            }
            if (boundary == null) {
                throw new IllegalStateException("Boundary not found");
            }
            NIOInputStream nioInputStream = multipartMixedEntry.getNIOInputStream();
            nioInputStream.notifyAvailable((ReadHandler)new MultipartReadHandler(multipartMixedEntry, partHandler, completionHandler, new MultipartContext(boundary, contentType, contentTypeProperties)));
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed((Throwable)e);
            }
            LOGGER.log(Level.WARNING, "Error occurred, but no CompletionHandler installed to handle it", e);
        }
    }
}

