/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.ajp;

import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.ajp.AjpHttpResponse;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.utils.BufferInputStream;

public final class AjpHttpRequest
extends HttpRequestPacket {
    private static final Logger LOGGER = Grizzly.logger(AjpHttpRequest.class);
    private static final ThreadCache.CachedTypeIndex<AjpHttpRequest> CACHE_IDX = ThreadCache.obtainIndex(AjpHttpRequest.class, 2);
    private final DataChunk instanceId = DataChunk.newInstance();
    private final DataChunk sslCert = DataChunk.newInstance();
    final DataChunk tmpDataChunk = DataChunk.newInstance();
    private String secret;
    private final AjpHttpResponse cachedResponse = new AjpHttpResponse();
    final ProcessingState processingState = new ProcessingState();
    private int contentBytesRemaining = -1;

    public static AjpHttpRequest create() {
        AjpHttpRequest httpRequestImpl = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpRequestImpl == null) {
            httpRequestImpl = new AjpHttpRequest();
        }
        return httpRequestImpl.init();
    }

    private AjpHttpRequest() {
    }

    @Override
    public Object getAttribute(String name) {
        X509Certificate[] result = super.getAttribute(name);
        if (result == null && "javax.servlet.request.X509Certificate".equals(name) && !this.sslCert.isNull()) {
            BufferChunk bc = this.sslCert.getBufferChunk();
            BufferInputStream bais = new BufferInputStream(bc.getBuffer(), bc.getStart(), bc.getEnd());
            X509Certificate[] jsseCerts = null;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                jsseCerts = new X509Certificate[]{cert};
            }
            catch (CertificateException e) {
                LOGGER.log(Level.SEVERE, "Certificate convertion failed", e);
                return null;
            }
            this.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
            result = jsseCerts;
        }
        return result;
    }

    public DataChunk instanceId() {
        return this.instanceId;
    }

    DataChunk sslCert() {
        return this.sslCert;
    }

    String getSecret() {
        return this.secret;
    }

    void setSecret(String secret) {
        this.secret = secret;
    }

    private AjpHttpRequest init() {
        this.cachedResponse.setRequest(this);
        this.setResponse(this.cachedResponse);
        return this;
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    public int getContentBytesRemaining() {
        return this.contentBytesRemaining;
    }

    public void setContentBytesRemaining(int contentBytesRemaining) {
        this.contentBytesRemaining = contentBytesRemaining;
    }

    @Override
    protected void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    @Override
    protected void setSecure(boolean secure) {
        super.setSecure(secure);
    }

    @Override
    protected void reset() {
        this.processingState.recycle();
        this.contentBytesRemaining = -1;
        this.cachedResponse.recycle();
        this.instanceId.recycle();
        this.sslCert.recycle();
        this.tmpDataChunk.recycle();
        this.secret = null;
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

