/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.portunif;

import java.io.IOException;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.portunif.PUFilter;

public class BackChannelFilter
extends BaseFilter {
    private final PUFilter puFilter;

    BackChannelFilter(PUFilter puFilter) {
        this.puFilter = puFilter;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        if (!this.isFilterChainRead(ctx)) {
            return ctx.getInvokeAction();
        }
        FilterChainContext suspendedParentContext = this.puFilter.suspendedContextAttribute.get(ctx);
        assert (suspendedParentContext != null);
        ReadResult readResult = suspendedParentContext.read();
        ctx.setMessage(readResult.getMessage());
        ctx.setAddress(readResult.getSrcAddress());
        readResult.recycle();
        return ctx.getInvokeAction();
    }

    private boolean isFilterChainRead(FilterChainContext ctx) {
        return ctx.getMessage() == null;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        FilterChainContext suspendedParentContext = this.puFilter.suspendedContextAttribute.get(ctx);
        assert (suspendedParentContext != null);
        suspendedParentContext.write(ctx.getAddress(), ctx.getMessage(), ctx.getTransportContext().getCompletionHandler());
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (BackChannelFilter.isDownstream(ctx)) {
            FilterChainContext suspendedParentContext = this.puFilter.suspendedContextAttribute.get(ctx);
            assert (suspendedParentContext != null);
            suspendedParentContext.notifyDownstream(event);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        if (BackChannelFilter.isDownstream(ctx)) {
            FilterChainContext suspendedParentContext = this.puFilter.suspendedContextAttribute.get(ctx);
            assert (suspendedParentContext != null);
            suspendedParentContext.fail(error);
        }
    }

    private static boolean isDownstream(FilterChainContext context) {
        return context.getStartIdx() > context.getEndIdx();
    }
}

