/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.URLDecoder;

public final class Parameters {
    private static final Logger logger = Grizzly.logger(Parameters.class);
    private final LinkedHashMap<String, String[]> paramHashStringArray = new LinkedHashMap();
    private boolean didQueryParameters = false;
    private boolean didMerge = false;
    MimeHeaders headers;
    DataChunk queryDC;
    public static final int INITIAL_SIZE = 4;
    private Parameters child = null;
    private Parameters parent = null;
    private Parameters currentChild = null;
    Charset encoding = null;
    Charset queryStringEncoding = null;
    final BufferChunk tmpName = new BufferChunk();
    final BufferChunk tmpValue = new BufferChunk();
    final CharChunk tmpNameC = new CharChunk(1024);
    final CharChunk tmpValueC = new CharChunk(1024);
    private static final int debug = 0;

    public void setQuery(DataChunk queryBC) {
        this.queryDC = queryBC;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setQueryStringEncoding(Charset queryStringEncoding) {
        this.queryStringEncoding = queryStringEncoding;
    }

    public void recycle() {
        this.paramHashStringArray.clear();
        this.didQueryParameters = false;
        this.currentChild = null;
        this.didMerge = false;
        this.encoding = null;
    }

    public Parameters getCurrentSet() {
        if (this.currentChild == null) {
            return this;
        }
        return this.currentChild;
    }

    public void push() {
        if (this.currentChild == null) {
            this.currentChild = new Parameters();
            this.currentChild.parent = this;
            return;
        }
        if (this.currentChild.child == null) {
            this.currentChild.child = new Parameters();
            this.currentChild.child.parent = this.currentChild;
        }
        this.currentChild = this.currentChild.child;
        this.currentChild.setEncoding(this.encoding);
    }

    public void pop() {
        if (this.currentChild == null) {
            throw new RuntimeException("Attempt to pop without a push");
        }
        this.currentChild.recycle();
        this.currentChild = this.currentChild.parent;
    }

    public void addParameterValues(String key, String[] newValues) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            String[] oldValues = this.paramHashStringArray.get(key);
            values = new String[oldValues.length + newValues.length];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            System.arraycopy(newValues, 0, values, oldValues.length, newValues.length);
        } else {
            values = newValues;
        }
        this.paramHashStringArray.put(key, values);
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            return this.currentChild.paramHashStringArray.get(name);
        }
        return this.paramHashStringArray.get(name);
    }

    public Set<String> getParameterNames() {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            this.currentChild.paramHashStringArray.keySet();
        }
        return this.paramHashStringArray.keySet();
    }

    private void merge() {
        this.handleQueryParameters();
        if (this.didMerge) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.parent.merge();
        LinkedHashMap<String, String[]> parentProps = this.parent.paramHashStringArray;
        Parameters.merge2(this.paramHashStringArray, parentProps);
        this.didMerge = true;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            if (values.length == 0) {
                return "";
            }
            return values[0];
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryDC == null || this.queryDC.isNull()) {
            return;
        }
        this.processParameters(this.queryDC, this.queryStringEncoding);
    }

    private static void merge2(LinkedHashMap<String, String[]> one, LinkedHashMap<String, String[]> two) {
        for (Map.Entry<String, String[]> entry : two.entrySet()) {
            String[] combinedValue;
            String name = entry.getKey();
            String[] oneValue = one.get(name);
            String[] twoValue = entry.getValue();
            if (twoValue == null) continue;
            if (oneValue == null) {
                combinedValue = new String[twoValue.length];
                System.arraycopy(twoValue, 0, combinedValue, 0, twoValue.length);
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            one.put(name, combinedValue);
        }
    }

    private void addParam(String key, String value) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            String[] oldValues = this.paramHashStringArray.get(key);
            values = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            values[oldValues.length] = value;
        } else {
            values = new String[]{value};
        }
        this.paramHashStringArray.put(key, values);
    }

    public void processParameters(Buffer buffer, int start, int len) {
        this.processParameters(buffer, start, len, this.encoding);
    }

    public void processParameters(Buffer buffer, int start, int len, Charset enc) {
        int end = start + len;
        int pos = start;
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = BufferChunk.indexOf(buffer, nameStart, end, '=');
            int nameEnd2 = BufferChunk.indexOf(buffer, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = BufferChunk.indexOf(buffer, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            this.tmpName.setBufferChunk(buffer, nameStart, nameEnd);
            this.tmpValue.setBufferChunk(buffer, valStart, valEnd);
            try {
                this.addParam(this.urlDecode(this.tmpName, enc), this.urlDecode(this.tmpValue, enc));
            }
            catch (IOException e) {
                // empty catch block
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
        } while (pos < end);
    }

    private String urlDecode(BufferChunk bc, Charset enc) throws IOException {
        String result;
        URLDecoder.decode(bc, true);
        if (enc != null) {
            result = bc.toString(enc);
        } else {
            CharChunk cc = this.tmpNameC;
            int length = bc.getLength();
            cc.allocate(length, -1);
            Buffer bbuf = bc.getBuffer();
            char[] cbuf = cc.getBuffer();
            int start = bc.getStart();
            for (int i = 0; i < length; ++i) {
                cbuf[i] = (char)(bbuf.get(i + start) & 0xFF);
            }
            cc.setChars(cbuf, 0, length);
            result = cc.toString();
            cc.recycle();
        }
        return result;
    }

    public void processParameters(char[] chars, int start, int len) {
        int end = start + len;
        int pos = start;
        do {
            boolean noEq = false;
            int nameStart = pos;
            int valStart = -1;
            int valEnd = -1;
            int nameEnd = CharChunk.indexOf(chars, nameStart, end, '=');
            int nameEnd2 = CharChunk.indexOf(chars, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = CharChunk.indexOf(chars, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(chars, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(chars, valStart, valEnd - valStart);
                URLDecoder.decode(this.tmpNameC, true);
                URLDecoder.decode(this.tmpValueC, true);
                this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(DataChunk data) {
        this.processParameters(data, this.encoding);
    }

    public void processParameters(DataChunk data, Charset encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        try {
            if (data.getType() == DataChunk.Type.Buffer) {
                BufferChunk bc = data.getBufferChunk();
                this.processParameters(bc.getBuffer(), bc.getStart(), bc.getLength(), encoding);
            } else {
                if (data.getType() != DataChunk.Type.Chars) {
                    data.toChars(encoding);
                }
                CharChunk cc = data.getCharChunk();
                this.processParameters(cc.getChars(), cc.getStart(), cc.getLength());
            }
        }
        catch (CharConversionException e) {
            throw new IllegalStateException(e);
        }
    }

    public String paramsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.paramHashStringArray.keySet()) {
            sb.append(s).append('=');
            String[] v = this.paramHashStringArray.get(s);
            for (int i = 0; i < v.length; ++i) {
                sb.append(v[i]).append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private void log(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Parameters: {0}", s);
        }
    }

    public void processSingleParameters(String str) {
        int end = str.length();
        int pos = 0;
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                URLDecoder.decode(this.tmpNameC, true);
                URLDecoder.decode(this.tmpValueC, true);
                if (str.compareTo(this.tmpNameC.toString()) == 0) {
                    this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(String str) {
        int end = str.length();
        int pos = 0;
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                URLDecoder.decode(this.tmpNameC, true);
                URLDecoder.decode(this.tmpValueC, true);
                this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }
}

