/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import org.glassfish.grizzly.memory.Buffers;

public class RequestURIRef {
    private boolean isDecoded;
    private Charset decodedURIEncoding;
    private boolean wasSlashAllowed = true;
    private Charset defaultURIEncoding = Charsets.UTF8_CHARSET;
    private final DataChunk originalRequestURIDC = DataChunk.newInstance();
    private final DataChunk requestURIDC = DataChunk.newInstance(new BufferChunk(){

        @Override
        public void notifyDirectUpdate() {
            super.notifyDirectUpdate();
            Buffer currentBuffer = this.getBuffer();
            if (currentBuffer == RequestURIRef.this.originalRequestURIDC.getBufferChunk().getBuffer()) {
                Buffer newBuffer = Buffers.cloneBuffer(currentBuffer, this.getStart(), this.getEnd());
                this.setBufferChunk(newBuffer, newBuffer.position(), newBuffer.limit());
            }
        }
    }, new CharChunk(), null);
    private final DataChunk decodedRequestURIDC = DataChunk.newInstance();
    private Buffer preallocatedDecodedURIBuffer;

    public void init(Buffer input, int start, int end) {
        this.originalRequestURIDC.setBuffer(input, start, end);
        this.requestURIDC.setBuffer(input, start, end);
    }

    public final DataChunk getOriginalRequestURIBC() {
        return this.originalRequestURIDC;
    }

    public final DataChunk getRequestURIBC() {
        return this.requestURIDC;
    }

    public final DataChunk getDecodedRequestURIBC() throws CharConversionException {
        return this.getDecodedRequestURIBC(this.wasSlashAllowed, this.defaultURIEncoding);
    }

    public DataChunk getDecodedRequestURIBC(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedRequestURIBC(isSlashAllowed, this.defaultURIEncoding);
    }

    public DataChunk getDecodedRequestURIBC(boolean isSlashAllowed, Charset charset) throws CharConversionException {
        if (this.isDecoded && isSlashAllowed == this.wasSlashAllowed && charset == this.decodedURIEncoding) {
            return this.decodedRequestURIDC;
        }
        this.checkDecodedURICapacity(this.requestURIDC.getLength());
        this.decodedRequestURIDC.setBuffer(this.preallocatedDecodedURIBuffer, 0, this.preallocatedDecodedURIBuffer.limit());
        HttpRequestURIDecoder.decode(this.requestURIDC, this.decodedRequestURIDC, isSlashAllowed, charset);
        this.isDecoded = true;
        this.wasSlashAllowed = isSlashAllowed;
        this.decodedURIEncoding = charset;
        return this.decodedRequestURIDC;
    }

    public String getURI() {
        return this.getURI(null);
    }

    public String getURI(Charset encoding) {
        return this.getRequestURIBC().toString(encoding);
    }

    public void setURI(String uri) {
        this.getRequestURIBC().setString(uri);
    }

    public final String getDecodedURI() throws CharConversionException {
        return this.getDecodedURI(this.wasSlashAllowed);
    }

    public final String getDecodedURI(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedURI(isSlashAllowed, null);
    }

    public String getDecodedURI(boolean isSlashAllowed, Charset encoding) throws CharConversionException {
        this.getDecodedRequestURIBC(isSlashAllowed, encoding);
        return this.decodedRequestURIDC.toString();
    }

    public void setDecodedURI(String uri) {
        this.decodedRequestURIDC.setString(uri);
        this.isDecoded = true;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public Charset getDefaultURIEncoding() {
        return this.defaultURIEncoding;
    }

    public void setDefaultURIEncoding(Charset defaultURIEncoding) {
        this.defaultURIEncoding = defaultURIEncoding;
    }

    public void recycle() {
        this.originalRequestURIDC.recycle();
        this.decodedRequestURIDC.recycle();
        this.requestURIDC.recycle();
        this.isDecoded = false;
        this.wasSlashAllowed = true;
        this.decodedURIEncoding = null;
        this.defaultURIEncoding = Charsets.UTF8_CHARSET;
    }

    private void checkDecodedURICapacity(int size) {
        if (this.preallocatedDecodedURIBuffer == null) {
            this.preallocatedDecodedURIBuffer = Buffers.wrap(null, new byte[size]);
        } else if (this.preallocatedDecodedURIBuffer.clear().remaining() < size) {
            this.preallocatedDecodedURIBuffer.dispose();
            this.preallocatedDecodedURIBuffer = Buffers.wrap(null, new byte[size]);
        }
    }
}

