/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.io.ReadHandler;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.Exceptions;

public class InputBuffer {
    private Request serverRequest;
    private HttpRequestPacket request;
    private FilterChainContext ctx;
    private boolean processingChars;
    private boolean closed;
    private Buffer inputContentBuffer;
    private Connection connection;
    private int markPos = -1;
    private int readAheadLimit = -1;
    private int readCount = 0;
    private String encoding = "ISO-8859-1";
    private CharsetDecoder decoder;
    private final Map<String, CharsetDecoder> decoders = new HashMap<String, CharsetDecoder>();
    private boolean contentRead;
    private ReadHandler handler;
    private int requestedSize;
    private boolean asyncEnabled;
    private final CharBuffer singleCharBuf = CharBuffer.allocate(1);
    private float averageCharsPerByte = 1.0f;
    private boolean isWaitingDataAsynchronously;

    public void initialize(Request serverRequest, FilterChainContext ctx) {
        if (serverRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx cannot be null.");
        }
        this.serverRequest = serverRequest;
        this.request = serverRequest.getRequest();
        this.ctx = ctx;
        this.connection = ctx.getConnection();
        Object message = ctx.getMessage();
        if (message instanceof HttpContent) {
            HttpContent content = (HttpContent)message;
            this.inputContentBuffer = content.getContent();
            this.contentRead = content.isLast();
            content.recycle();
            this.inputContentBuffer.allowBufferDispose(true);
        }
    }

    public void setDefaultEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void recycle() {
        this.inputContentBuffer.tryDispose();
        this.inputContentBuffer = null;
        this.connection = null;
        this.decoder = null;
        this.ctx = null;
        this.handler = null;
        this.processingChars = false;
        this.closed = false;
        this.contentRead = false;
        this.asyncEnabled = false;
        this.markPos = -1;
        this.readAheadLimit = -1;
        this.requestedSize = -1;
        this.readCount = 0;
        this.averageCharsPerByte = 1.0f;
        this.isWaitingDataAsynchronously = false;
        this.encoding = "ISO-8859-1";
    }

    public void processingChars() {
        if (!this.processingChars) {
            this.processingChars = true;
            String enc = this.request.getCharacterEncoding();
            if (enc != null) {
                this.encoding = enc;
                CharsetDecoder localDecoder = this.getDecoder();
                this.averageCharsPerByte = localDecoder.averageCharsPerByte();
            }
        }
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.inputContentBuffer.hasRemaining() && this.fill(1) == -1) {
            return -1;
        }
        if (this.readAheadLimit != -1) {
            ++this.readCount;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        return this.inputContentBuffer.get() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.asyncEnabled && !this.inputContentBuffer.hasRemaining() && this.fill(1) == -1) {
            return -1;
        }
        int nlen = Math.min(this.inputContentBuffer.remaining(), len);
        if (this.readAheadLimit != -1) {
            this.readCount += nlen;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        this.inputContentBuffer.get(b, off, nlen);
        this.inputContentBuffer.shrink();
        return nlen;
    }

    public int readyData() {
        if (this.closed) {
            return 0;
        }
        return this.processingChars ? this.availableChar() : this.available();
    }

    public int available() {
        return this.closed ? 0 : this.inputContentBuffer.remaining();
    }

    public Buffer getBuffer() {
        return this.inputContentBuffer;
    }

    public Buffer readBuffer() {
        Buffer buffer = this.inputContentBuffer;
        this.inputContentBuffer = Buffers.EMPTY_BUFFER;
        return buffer;
    }

    public ReadHandler getReadHandler() {
        return this.handler;
    }

    public int read(CharBuffer target) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null.");
        }
        int read = this.fillChar(target.capacity(), target, !this.asyncEnabled, true);
        if (this.readAheadLimit != -1) {
            this.readCount += read;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        return read;
    }

    public int readChar() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        this.singleCharBuf.position(0);
        int read = this.read(this.singleCharBuf);
        if (read == -1) {
            return -1;
        }
        char c = this.singleCharBuf.get(0);
        this.singleCharBuf.position(0);
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        if (len == 0) {
            return 0;
        }
        CharBuffer buf = CharBuffer.wrap(cbuf, off, len);
        return this.read(buf);
    }

    public boolean ready() {
        if (this.closed) {
            return false;
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        return this.inputContentBuffer.hasRemaining() || this.request.isExpectContent();
    }

    public void fillFully(int length) throws IOException {
        int remaining = length - this.inputContentBuffer.remaining();
        if (remaining > 0) {
            this.fill(remaining);
        }
    }

    public int availableChar() {
        return (int)((float)this.inputContentBuffer.remaining() * this.averageCharsPerByte);
    }

    public void mark(int readAheadLimit) {
        if (readAheadLimit > 0) {
            this.markPos = this.inputContentBuffer.position();
            this.readCount = 0;
            this.readAheadLimit = readAheadLimit;
        }
    }

    public boolean markSupported() {
        if (this.processingChars) {
            throw new IllegalStateException();
        }
        return true;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.readAheadLimit == -1 && this.markPos == -1) {
            throw new IOException("Mark not set");
        }
        if (this.readAheadLimit != -1) {
            if (this.markPos == -1) {
                throw new IOException("Mark not set");
            }
            this.readCount = 0;
        }
        this.inputContentBuffer.position(this.markPos);
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public long skip(long n, boolean block) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!block && n > (long)this.inputContentBuffer.remaining()) {
            throw new IllegalStateException("Can not skip more bytes than available");
        }
        if (!this.processingChars) {
            if (n <= 0L) {
                return 0L;
            }
            if (block) {
                if (!this.inputContentBuffer.hasRemaining() && this.fill((int)n) == -1) {
                    return -1L;
                }
                if ((long)this.inputContentBuffer.remaining() < n) {
                    this.fill((int)n);
                }
            }
            long nlen = Math.min((long)this.inputContentBuffer.remaining(), n);
            this.inputContentBuffer.position(this.inputContentBuffer.position() + (int)nlen);
            this.inputContentBuffer.shrink();
            return nlen;
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        CharBuffer skipBuffer = CharBuffer.allocate((int)n);
        if (this.fillChar((int)n, skipBuffer, block, true) == -1) {
            return 0L;
        }
        return Math.min((long)skipBuffer.remaining(), n);
    }

    public void finished() throws IOException {
        if (!this.contentRead) {
            this.contentRead = true;
            ReadHandler localHandler = this.handler;
            if (localHandler != null) {
                this.handler = null;
                try {
                    localHandler.onAllDataRead();
                }
                catch (Throwable t) {
                    localHandler.onError(t);
                    throw Exceptions.makeIOException(t);
                }
            }
        }
    }

    public boolean isFinished() {
        return this.contentRead;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void notifyAvailable(ReadHandler handler) {
        this.notifyAvailable(handler, 0);
    }

    public void notifyAvailable(ReadHandler handler, int size) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null.");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        if (this.handler != null) {
            throw new IllegalStateException("Illegal attempt to register a new handler before the existing handler has been notified");
        }
        if (this.closed || this.isFinished()) {
            try {
                handler.onAllDataRead();
            }
            catch (Exception ioe) {
                handler.onError(ioe);
            }
            return;
        }
        int available = this.readyData();
        if (InputBuffer.shouldNotifyNow(size, available)) {
            try {
                handler.onDataAvailable();
            }
            catch (Exception ioe) {
                handler.onError(ioe);
            }
            return;
        }
        this.requestedSize = size;
        this.handler = handler;
        if (!this.isWaitingDataAsynchronously) {
            this.isWaitingDataAsynchronously = true;
            this.serverRequest.initiateAsyncronousDataReceiving();
        }
    }

    public boolean append(Buffer buffer) throws IOException {
        if (buffer == null) {
            return false;
        }
        if (this.closed) {
            buffer.dispose();
        } else {
            int addSize = buffer.remaining();
            if (addSize > 0) {
                int available;
                this.updateInputContentBuffer(buffer);
                if (this.handler != null && (available = this.readyData()) > this.requestedSize) {
                    ReadHandler localHandler = this.handler;
                    this.handler = null;
                    try {
                        localHandler.onDataAvailable();
                    }
                    catch (Throwable t) {
                        localHandler.onError(t);
                        throw Exceptions.makeIOException(t);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }

    public void terminate() {
        ReadHandler localHandler = this.handler;
        if (localHandler != null) {
            this.handler = null;
            if (this.connection.isOpen()) {
                localHandler.onError(new CancellationException());
            } else {
                localHandler.onError(new EOFException());
            }
        }
    }

    private int fill(int requestedLen) throws IOException {
        int read;
        Buffer b;
        for (read = 0; read < requestedLen && this.request.isExpectContent(); read += b.remaining()) {
            ReadResult rr = this.ctx.read();
            HttpContent c = (HttpContent)rr.getMessage();
            b = c.getContent();
            this.updateInputContentBuffer(b);
            rr.recycle();
            c.recycle();
        }
        if (read > 0 || requestedLen == 0) {
            return read;
        }
        return -1;
    }

    private int fillChar(int requestedLen, CharBuffer dst, boolean block, boolean flip) throws IOException {
        if (this.inputContentBuffer.hasRemaining() || !block) {
            CharsetDecoder decoderLocal = this.getDecoder();
            int charPos = dst.position();
            ByteBuffer bb = this.inputContentBuffer.toByteBuffer();
            int bbPos = bb.position();
            CoderResult result = decoderLocal.decode(bb, dst, false);
            if (result == CoderResult.UNDERFLOW && block) {
                this.fill(1);
                decoderLocal.decode(bb, dst, false);
            }
            int readChars = dst.position() - charPos;
            int readBytes = bb.position() - bbPos;
            bb.position(bbPos);
            this.inputContentBuffer.position(this.inputContentBuffer.position() + readBytes);
            if (this.readAheadLimit == -1) {
                this.inputContentBuffer.shrink();
            }
            if (this.inputContentBuffer.hasRemaining() && readChars < requestedLen) {
                readChars += this.fillChar(0, dst, false, false);
            }
            if (flip) {
                dst.flip();
            }
            return readChars;
        }
        if (this.request.isExpectContent()) {
            int read = 0;
            CharsetDecoder decoderLocal = this.getDecoder();
            boolean isNeedMoreInput = false;
            boolean last = false;
            while (read < requestedLen && this.request.isExpectContent()) {
                if (isNeedMoreInput || !this.inputContentBuffer.hasRemaining()) {
                    ReadResult rr = this.ctx.read();
                    HttpContent c = (HttpContent)rr.getMessage();
                    this.updateInputContentBuffer(c.getContent());
                    last = c.isLast();
                    rr.recycle();
                    c.recycle();
                    isNeedMoreInput = false;
                }
                ByteBuffer bytes = this.inputContentBuffer.toByteBuffer();
                int bytesPos = bytes.position();
                int dstPos = dst.position();
                CoderResult result = decoderLocal.decode(bytes, dst, false);
                int producesChars = dst.position() - dstPos;
                int consumedBytes = bytes.position() - bytesPos;
                read += producesChars;
                if (consumedBytes > 0) {
                    bytes.position(bytesPos);
                    this.inputContentBuffer.position(this.inputContentBuffer.position() + consumedBytes);
                    this.inputContentBuffer.shrink();
                } else {
                    isNeedMoreInput = true;
                }
                if (!last && result != CoderResult.OVERFLOW) continue;
                break;
            }
            if (flip) {
                dst.flip();
            }
            if (last && read == 0) {
                read = -1;
            }
            return read;
        }
        return -1;
    }

    private void updateInputContentBuffer(Buffer buffer) {
        buffer.allowBufferDispose(true);
        if (this.inputContentBuffer.hasRemaining()) {
            this.toCompositeInputContentBuffer().append(buffer);
        } else {
            this.inputContentBuffer.tryDispose();
            this.inputContentBuffer = buffer;
        }
    }

    private static boolean shouldNotifyNow(int size, int available) {
        return available != 0 && available >= size;
    }

    private CharsetDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = this.decoders.get(this.encoding);
            if (this.decoder == null) {
                Charset cs = Charsets.lookupCharset(this.encoding);
                this.decoder = cs.newDecoder();
                this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
                this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.decoders.put(this.encoding, this.decoder);
            } else {
                this.decoder.reset();
            }
        }
        return this.decoder;
    }

    private CompositeBuffer toCompositeInputContentBuffer() {
        if (!this.inputContentBuffer.isComposite()) {
            CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer(this.connection.getTransport().getMemoryManager());
            compositeBuffer.allowBufferDispose(true);
            compositeBuffer.allowInternalBuffersDispose(true);
            compositeBuffer.append(this.inputContentBuffer);
            this.inputContentBuffer = compositeBuffer;
        }
        return (CompositeBuffer)this.inputContentBuffer;
    }
}

