/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.ServletContextImpl;

public class HttpSessionImpl
implements HttpSession {
    private static final Logger LOGGER = Grizzly.logger(HttpSessionImpl.class);
    private Session session;
    private final ServletContextImpl contextImpl;
    private Long creationTime;
    private Long lastAccessed;
    private boolean isNew = true;

    public HttpSessionImpl(ServletContextImpl contextImpl) {
        this.contextImpl = contextImpl;
        this.lastAccessed = this.creationTime = Long.valueOf(System.currentTimeMillis());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.session.getIdInternal();
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    protected void access() {
        this.lastAccessed = System.currentTimeMillis();
        this.session.setTimestamp(this.lastAccessed);
        this.isNew = false;
    }

    public ServletContext getServletContext() {
        return this.contextImpl;
    }

    public void setMaxInactiveInterval(int sessionTimeout) {
        this.session.setSessionTimeout(sessionTimeout);
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getSessionTimeout();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String key) {
        return this.session.getAttribute(key);
    }

    public Object getValue(String value) {
        return this.session.getAttribute(value);
    }

    public Enumeration getAttributeNames() {
        return this.session.attributes().keys();
    }

    public String[] getValueNames() {
        return this.session.attributes().entrySet().toArray(new String[0]);
    }

    public void setAttribute(String key, Object value) {
        List<EventListener> listeners;
        HttpSessionBindingEvent event;
        Object unbound;
        block15: {
            block14: {
                if (value == null) {
                    this.removeAttribute(key);
                    return;
                }
                unbound = this.session.getAttribute(key);
                this.session.setAttribute(key, value);
                if (unbound != null && unbound != value && unbound instanceof HttpSessionBindingListener) {
                    try {
                        ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, key));
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block14;
                        LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_SESSION_LISTENER_UNBOUND_ERROR(unbound.getClass().getName()));
                    }
                }
            }
            event = null;
            if (value instanceof HttpSessionBindingListener && value != unbound) {
                event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                try {
                    ((HttpSessionBindingListener)value).valueBound(event);
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block15;
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_SESSION_LISTENER_BOUND_ERROR(value.getClass().getName()));
                }
            }
        }
        if ((listeners = this.contextImpl.getListeners()).isEmpty()) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.get(i);
            try {
                if (unbound != null) {
                    if (event == null) {
                        event = new HttpSessionBindingEvent((HttpSession)this, key, unbound);
                    }
                    listener.attributeReplaced(event);
                    continue;
                }
                if (event == null) {
                    event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR("HttpSessionAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    public void putValue(String key, Object value) {
        this.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        List<EventListener> listeners;
        Object value = this.session.removeAttribute(key);
        if (value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = this.contextImpl.getListeners()).isEmpty()) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR("HttpSessionAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    public void removeValue(String key) {
        this.removeAttribute(key);
    }

    public synchronized void invalidate() {
        this.session.setValid(false);
        this.session.attributes().clear();
        this.creationTime = 0L;
        this.isNew = true;
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (int i = 0; i < listeners.size(); ++i) {
                EventListener listenerObj = listeners.get(i);
                if (!(listenerObj instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listenerObj;
                try {
                    listener.sessionDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR("sessionDestroyed", "HttpSessionListener", listener.getClass().getName()), t);
                }
            }
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void notifyNew() {
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (int i = 0; i < listeners.size(); ++i) {
                EventListener listenerObj = listeners.get(i);
                if (!(listenerObj instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listenerObj;
                try {
                    listener.sessionCreated(event);
                    continue;
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR("sessionCreated", "HttpSessionListener", listener.getClass().getName()), t);
                }
            }
        }
    }
}

