/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.io.NIOReader;
import org.glassfish.grizzly.http.multipart.ContentDisposition;
import org.glassfish.grizzly.http.multipart.MultipartContext;
import org.glassfish.grizzly.http.multipart.MultipartEntryNIOInputStream;
import org.glassfish.grizzly.http.multipart.MultipartEntryNIOReader;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.http.util.Header;

public class MultipartEntry {
    private static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=US-ASCII";
    private static final String DEFAULT_CONTENT_ENCODING = "US-ASCII";
    private NIOInputStream requestInputStream;
    private final MultipartContext multipartContext;
    private final MultipartEntryNIOInputStream inputStream;
    private final MultipartEntryNIOReader reader;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String contentType = "text/plain; charset=US-ASCII";
    private ContentDisposition contentDisposition;
    private int availableBytes;
    private int reservedBytes;
    private boolean isFinished;
    private boolean isSkipping;
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    private boolean isMultipart;
    private boolean isMultipartParsed;

    MultipartEntry(MultipartContext multipartContext) {
        this.inputStream = new MultipartEntryNIOInputStream(this);
        this.reader = new MultipartEntryNIOReader(this);
        this.multipartContext = multipartContext;
    }

    void initialize(NIOInputStream parentInputStream) {
        this.requestInputStream = parentInputStream;
    }

    public NIOInputStream getNIOInputStream() {
        if (this.usingReader) {
            throw new IllegalStateException("MultipartEntry is in the character mode");
        }
        if (!this.usingInputStream) {
            this.inputStream.initialize(this.requestInputStream);
        }
        this.usingInputStream = true;
        return this.inputStream;
    }

    public NIOReader getNIOReader() {
        if (this.usingInputStream) {
            throw new IllegalStateException("MultipartEntry is in the binary mode");
        }
        if (!this.usingReader) {
            this.reader.initialize(this.requestInputStream, this.getEncoding());
        }
        this.usingReader = true;
        return this.reader;
    }

    public MultipartContext getMultipartContext() {
        return this.multipartContext;
    }

    public boolean isMultipart() {
        if (!this.isMultipartParsed) {
            this.isMultipartParsed = true;
            this.isMultipart = this.contentType != null && this.contentType.toLowerCase().startsWith("multipart");
        }
        return this.isMultipart;
    }

    public String getContentType() {
        return this.contentType;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    void setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(Header header) {
        return this.headers.get(header.toString());
    }

    void setHeader(Header header, String value) {
        this.headers.put(header.toString(), value);
    }

    public void skip() throws IOException {
        this.isSkipping = true;
        this.requestInputStream.skip(this.availableBytes);
        this.availableBytes = 0;
    }

    protected String getEncoding() {
        String contentEncoding = ContentType.getCharsetFromContentType(this.getContentType());
        return contentEncoding != null ? contentEncoding : DEFAULT_CONTENT_ENCODING;
    }

    void reset() {
        this.headers.clear();
        this.contentType = DEFAULT_CONTENT_TYPE;
        this.contentDisposition = null;
        this.availableBytes = 0;
        this.reservedBytes = 0;
        this.isFinished = false;
        this.isSkipping = false;
        this.usingInputStream = false;
        this.usingReader = false;
        this.inputStream.recycle();
        this.reader.recycle();
        this.isMultipartParsed = false;
    }

    void onFinished() {
        this.isFinished = true;
        this.onDataReceived();
    }

    void onDataReceived() {
        if (this.isSkipping) {
            try {
                this.requestInputStream.skip(this.availableBytes);
                this.availableBytes = 0;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected exception", e);
            }
            return;
        }
        if (this.usingInputStream) {
            this.inputStream.onDataCame();
        } else if (this.usingReader) {
            this.reader.onDataCame();
        }
    }

    boolean isFinished() {
        return this.isFinished;
    }

    int availableBytes() {
        return this.availableBytes;
    }

    void addAvailableBytes(int delta) {
        this.availableBytes += delta;
    }

    int getReservedBytes() {
        return this.reservedBytes;
    }

    void setReservedBytes(int reservedBytes) {
        this.reservedBytes = reservedBytes;
    }
}

