/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class HeadersFrame
extends HeaderBlockHead {
    private static final ThreadCache.CachedTypeIndex<HeadersFrame> CACHE_IDX = ThreadCache.obtainIndex(HeadersFrame.class, 8);
    public static final int TYPE = 1;
    public static final byte END_STREAM = 1;
    public static final byte PRIORITIZED = 32;
    static final Map<Integer, String> FLAG_NAMES_MAP = new HashMap<Integer, String>(8);
    private boolean exclusive;
    private int streamDependency;
    private int weight;

    private HeadersFrame() {
    }

    public static HeadersFrame fromBuffer(int flags, int streamId, Buffer buffer) {
        HeadersFrame frame = HeadersFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        if (frame.isFlagSet(8)) {
            frame.padLength = buffer.get() & 0xFF;
        }
        if (frame.isFlagSet(32)) {
            int dependency = buffer.getInt();
            frame.exclusive = ((long)dependency & 0x80000000L) != 0L;
            frame.streamDependency = dependency & Integer.MAX_VALUE;
            frame.weight = buffer.get() & 0xFF;
        }
        frame.compressedHeaders = buffer.split(buffer.position());
        frame.setFrameBuffer(buffer);
        return frame;
    }

    static HeadersFrame create() {
        HeadersFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new HeadersFrame();
        }
        return frame;
    }

    public static HeadersFrameBuilder builder() {
        return new HeadersFrameBuilder();
    }

    public HeadersFrame normalize() {
        if (this.isPadded()) {
            this.clearFlag(8);
            this.compressedHeaders.limit(this.compressedHeaders.limit() - this.padLength);
            this.padLength = 0;
            this.onPayloadUpdated();
        }
        return this;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isEndStream() {
        return this.isFlagSet(1);
    }

    public boolean isPrioritized() {
        return this.isFlagSet(32);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HeadersFrame {").append(this.headerToString()).append(", streamDependency=").append(this.streamDependency).append(", exclusive=").append(this.exclusive).append(", weight=").append(this.weight).append(", padLength=").append(this.padLength).append(", compressedHeaders=").append(this.compressedHeaders).append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.padLength = 0;
        this.streamDependency = 0;
        this.weight = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        boolean isPadded = this.isFlagSet(8);
        boolean isPrioritySet = this.isFlagSet(32);
        int extraHeaderLen = (isPadded ? 1 : 0) + (isPrioritySet ? 5 : 0);
        Object buffer = memoryManager.allocate(9 + extraHeaderLen);
        this.serializeFrameHeader((Buffer)buffer);
        if (isPadded) {
            buffer.put((byte)(this.padLength & 0xFF));
        }
        if (isPrioritySet) {
            buffer.putInt(this.streamDependency);
            buffer.put((byte)(this.weight & 0xFF));
        }
        buffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer(memoryManager, new Buffer[]{buffer, this.compressedHeaders});
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    protected int calcLength() {
        boolean isPadded = this.isFlagSet(8);
        boolean isPrioritySet = this.isFlagSet(32);
        return (isPadded ? 1 : 0) + (isPrioritySet ? 5 : 0) + (this.compressedHeaders != null ? this.compressedHeaders.remaining() : 0);
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return FLAG_NAMES_MAP;
    }

    static {
        FLAG_NAMES_MAP.putAll(HeaderBlockHead.FLAG_NAMES_MAP);
        FLAG_NAMES_MAP.put(1, "END_STREAM");
        FLAG_NAMES_MAP.put(32, "PRIORITIZED");
    }

    public static class HeadersFrameBuilder
    extends HeaderBlockHead.HeaderBlockHeadBuilder<HeadersFrameBuilder> {
        private int padLength;
        private int streamDependency;
        private int weight;

        protected HeadersFrameBuilder() {
        }

        public HeadersFrameBuilder endStream(boolean endStream) {
            if (endStream) {
                this.setFlag(1);
            }
            return this;
        }

        @Override
        public HeadersFrameBuilder padded(boolean isPadded) {
            if (isPadded) {
                this.setFlag(8);
            }
            return this;
        }

        public HeadersFrameBuilder prioritized(boolean isPrioritized) {
            if (isPrioritized) {
                this.setFlag(32);
            }
            return this;
        }

        @Override
        public HeadersFrameBuilder padLength(int padLength) {
            this.padLength = padLength;
            return this;
        }

        public HeadersFrameBuilder streamDependency(int streamDependency) {
            this.streamDependency = streamDependency;
            return this;
        }

        public HeadersFrameBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public HeadersFrame build() {
            HeadersFrame frame = HeadersFrame.create();
            this.setHeaderValuesTo(frame);
            frame.compressedHeaders = this.compressedHeaders;
            frame.padLength = this.padLength;
            frame.streamDependency = this.streamDependency;
            frame.weight = this.weight;
            return frame;
        }

        @Override
        protected HeadersFrameBuilder getThis() {
            return this;
        }
    }
}

