/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.EncoderDecoderUtilsBase;
import org.glassfish.grizzly.http2.HeadersEncoder;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.Charsets;

class EncoderUtils
extends EncoderDecoderUtilsBase {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    EncoderUtils() {
    }

    static Buffer encodeResponseHeaders(Http2Session http2Session, HttpResponsePacket response, Map<String, String> capture) throws IOException {
        assert (http2Session.getDeflaterLock().isLocked());
        MimeHeaders headers = response.getHeaders();
        headers.removeHeader(Header.Connection);
        headers.removeHeader(Header.KeepAlive);
        headers.removeHeader(Header.ProxyConnection);
        headers.removeHeader(Header.TransferEncoding);
        headers.removeHeader(Header.Upgrade);
        HeadersEncoder encoder = http2Session.getHeadersEncoder();
        encoder.encodeHeader(":status", String.valueOf(response.getHttpStatus().getStatusCode()), capture);
        EncoderUtils.encodeUserHeaders(headers, encoder, capture);
        return encoder.flushHeaders();
    }

    static Buffer encodeRequestHeaders(Http2Session http2Session, HttpRequestPacket request, Map<String, String> capture) throws IOException {
        assert (http2Session.getDeflaterLock().isLocked());
        int schemeStart = -1;
        int schemeLen = -1;
        String requestURI = request.getRequestURI().trim();
        int len = requestURI.length();
        int idx = requestURI.indexOf(47);
        if (idx > 0 && idx < len - 1 && requestURI.charAt(idx - 1) == ':' && requestURI.charAt(idx + 1) == '/') {
            schemeStart = 0;
            schemeLen = idx - 1;
        }
        int pathStart = schemeStart == -1 ? idx : requestURI.indexOf(47, idx + 2);
        int pathLen = len - pathStart;
        if (pathStart == -1) {
            throw new IllegalStateException("Request URI path is not set");
        }
        MimeHeaders headers = request.getHeaders();
        String hostHeader = headers.getHeader(Header.Host);
        if (hostHeader == null) {
            if (schemeStart == -1) {
                throw new IllegalStateException("Missing the Host header");
            }
            hostHeader = requestURI.substring(schemeStart + schemeLen + 3, pathStart);
        }
        headers.removeHeader(Header.Connection);
        headers.removeHeader(Header.KeepAlive);
        headers.removeHeader(Header.ProxyConnection);
        headers.removeHeader(Header.TransferEncoding);
        headers.removeHeader(Header.Upgrade);
        HeadersEncoder encoder = http2Session.getHeadersEncoder();
        encoder.encodeHeader(":method", request.getMethod().toString(), capture);
        if (schemeLen > 0) {
            encoder.encodeHeader(":scheme", requestURI.substring(0, schemeLen), capture);
        } else {
            encoder.encodeHeader(":scheme", SSLUtils.getSSLEngine(http2Session.getConnection()) == null ? HTTP : HTTPS, capture);
        }
        encoder.encodeHeader(":authority", hostHeader, capture);
        String path = pathLen == requestURI.length() ? requestURI : requestURI.substring(pathStart, pathStart + pathLen);
        DataChunk query = request.getQueryStringDC();
        if (!query.isNull()) {
            path = path + '?' + query.toString(Charsets.UTF8_CHARSET);
        }
        encoder.encodeHeader(":path", path, capture);
        EncoderUtils.encodeUserHeaders(headers, encoder, capture);
        return encoder.flushHeaders();
    }

    static Buffer encodeTrailerHeaders(Http2Session http2Session, MimeHeaders trailers, Map<String, String> capture) {
        assert (http2Session.getDeflaterLock().isLocked());
        if (trailers == null || trailers.size() == 0) {
            return Buffers.EMPTY_BUFFER;
        }
        HeadersEncoder encoder = http2Session.getHeadersEncoder();
        for (String name : trailers.names()) {
            encoder.encodeHeader(name, trailers.getHeader(name), capture);
        }
        return encoder.flushHeaders();
    }

    private static void encodeUserHeaders(MimeHeaders headers, HeadersEncoder encoder, Map<String, String> capture) throws IOException {
        int mimeHeadersCount = headers.size();
        ArrayList<DataChunk> tmpList = null;
        for (int i = 0; i < mimeHeadersCount; ++i) {
            String valueStr;
            DataChunk name;
            int valueSize = 0;
            if (headers.setSerialized(i, true) || (name = headers.getName(i)).isNull() || name.getLength() == 0) continue;
            DataChunk value1 = headers.getValue(i);
            for (int j = i; j < mimeHeadersCount; ++j) {
                if (headers.isSerialized(j) || !name.equalsIgnoreCase(headers.getName(j))) continue;
                headers.setSerialized(j, true);
                DataChunk value = headers.getValue(j);
                if (value.isNull()) continue;
                if (tmpList == null || tmpList.isEmpty()) {
                    tmpList = new ArrayList<DataChunk>(2);
                    if (!value1.isNull()) {
                        tmpList.add(value1);
                        valueSize += value1.getLength();
                    }
                }
                tmpList.add(value);
                valueSize += value.getLength();
            }
            String nameStr = EncoderUtils.nameToLowerCase(name);
            if (tmpList != null && !tmpList.isEmpty()) {
                int j;
                int valuesCount = tmpList.size();
                StringBuilder sb = new StringBuilder(valueSize += valuesCount - 1);
                for (j = 0; j < valuesCount - 1; ++j) {
                    sb.append(((DataChunk)tmpList.get(j)).toString());
                    sb.append('\u0000');
                }
                sb.append(((DataChunk)tmpList.get(j)).toString());
                valueStr = sb.toString();
                tmpList.clear();
            } else {
                valueStr = value1.toString();
            }
            encoder.encodeHeader(nameStr, valueStr, capture);
        }
    }

    private static byte[] nameToLowerCaseByteArray(DataChunk name) {
        int length = name.getLength();
        byte[] lowercase = new byte[length];
        if (name.getType() == DataChunk.Type.Bytes) {
            ByteChunk byteChunk = name.getByteChunk();
            byte[] bytes = byteChunk.getBuffer();
            int offs = byteChunk.getStart();
            for (int i = 0; i < length; ++i) {
                lowercase[i] = (byte)Ascii.toLower(bytes[i + offs]);
            }
        } else if (name.getType() == DataChunk.Type.Buffer) {
            BufferChunk bufferChunk = name.getBufferChunk();
            Buffer buffer = bufferChunk.getBuffer();
            int offs = bufferChunk.getStart();
            for (int i = 0; i < length; ++i) {
                lowercase[i] = (byte)Ascii.toLower(buffer.get(i + offs));
            }
        } else {
            String s = name.toString();
            for (int i = 0; i < length; ++i) {
                lowercase[i] = (byte)Ascii.toLower(s.charAt(i));
            }
        }
        return lowercase;
    }

    private static String nameToLowerCase(DataChunk name) {
        int length = name.getLength();
        StringBuilder sb = new StringBuilder(length);
        if (name.getType() == DataChunk.Type.Bytes) {
            ByteChunk byteChunk = name.getByteChunk();
            byte[] bytes = byteChunk.getBuffer();
            int offs = byteChunk.getStart();
            for (int i = 0; i < length; ++i) {
                sb.append((char)Ascii.toLower(bytes[i + offs]));
            }
        } else if (name.getType() == DataChunk.Type.Buffer) {
            BufferChunk bufferChunk = name.getBufferChunk();
            Buffer buffer = bufferChunk.getBuffer();
            int offs = bufferChunk.getStart();
            for (int i = 0; i < length; ++i) {
                sb.append((char)Ascii.toLower(buffer.get(i + offs)));
            }
        } else {
            String s = name.toString();
            for (int i = 0; i < length; ++i) {
                sb.append((char)Ascii.toLower(s.charAt(i)));
            }
        }
        return sb.toString();
    }

    private static int valueToByteArray(DataChunk value, byte[] dstArray, int arrayOffs) {
        int length = value.getLength();
        if (value.getType() == DataChunk.Type.Bytes) {
            ByteChunk byteChunk = value.getByteChunk();
            byte[] bytes = byteChunk.getBuffer();
            int offs = byteChunk.getStart();
            System.arraycopy(bytes, offs, dstArray, arrayOffs, length);
        } else if (value.getType() == DataChunk.Type.Buffer) {
            BufferChunk bufferChunk = value.getBufferChunk();
            Buffer buffer = bufferChunk.getBuffer();
            int offs = bufferChunk.getStart();
            int oldPos = buffer.position();
            int oldLim = buffer.limit();
            Buffers.setPositionLimit(buffer, offs, offs + length);
            buffer.get(dstArray, arrayOffs, length);
            Buffers.setPositionLimit(buffer, oldPos, oldLim);
        } else {
            String s = value.toString();
            for (int i = 0; i < length; ++i) {
                dstArray[arrayOffs + i] = (byte)s.charAt(i);
            }
        }
        return length;
    }

    private static byte[] valueToByteArray(DataChunk value) {
        int length = value.getLength();
        if (value.getType() == DataChunk.Type.Bytes) {
            ByteChunk byteChunk = value.getByteChunk();
            byte[] bytes = byteChunk.getBuffer();
            int offs = byteChunk.getStart();
            if (bytes.length == length) {
                return bytes;
            }
            byte[] dstArray = new byte[length];
            System.arraycopy(bytes, offs, dstArray, 0, length);
            return dstArray;
        }
        if (value.getType() == DataChunk.Type.Buffer) {
            BufferChunk bufferChunk = value.getBufferChunk();
            Buffer buffer = bufferChunk.getBuffer();
            if (buffer.hasArray() && buffer.array().length == length) {
                return buffer.array();
            }
            byte[] dstArray = new byte[length];
            int offs = bufferChunk.getStart();
            int oldPos = buffer.position();
            int oldLim = buffer.limit();
            Buffers.setPositionLimit(buffer, offs, offs + length);
            buffer.get(dstArray);
            Buffers.setPositionLimit(buffer, oldPos, oldLim);
            return dstArray;
        }
        byte[] dstArray = new byte[length];
        String s = value.toString();
        for (int i = 0; i < length; ++i) {
            dstArray[i] = (byte)s.charAt(i);
        }
        return dstArray;
    }
}

