/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.tmpselectors;

import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;

public class TemporarySelectorIO {
    private static final Logger LOGGER = Grizzly.logger(TemporarySelectorIO.class);
    protected TemporarySelectorPool selectorPool;
    private final Reader<SocketAddress> reader;
    private final Writer<SocketAddress> writer;

    public TemporarySelectorIO(Reader<SocketAddress> reader, Writer<SocketAddress> writer) {
        this(reader, writer, null);
    }

    public TemporarySelectorIO(Reader<SocketAddress> reader, Writer<SocketAddress> writer, TemporarySelectorPool selectorPool) {
        this.reader = reader;
        this.writer = writer;
        this.selectorPool = selectorPool;
    }

    public TemporarySelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public void setSelectorPool(TemporarySelectorPool selectorPool) {
        this.selectorPool = selectorPool;
    }

    public Reader<SocketAddress> getReader() {
        return this.reader;
    }

    public Writer<SocketAddress> getWriter() {
        return this.writer;
    }

    protected void recycleTemporaryArtifacts(Selector selector, SelectionKey selectionKey) {
        if (selectionKey != null) {
            try {
                selectionKey.cancel();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TEMPORARY_SELECTOR_IO_CANCEL_KEY_EXCEPTION(selectionKey), e);
            }
        }
        if (selector != null) {
            this.selectorPool.offer(selector);
        }
    }
}

