/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.util.DispatcherHelper;
import org.glassfish.grizzly.http.server.util.Enumerator;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.server.util.MimeType;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.RequestDispatcherImpl;
import org.glassfish.grizzly.servlet.ServletHandler;

public class ServletContextImpl
implements ServletContext {
    private final transient ArrayList<EventListener> eventListeners = new ArrayList();
    private final ConcurrentHashMap<String, String> parameters = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap attributes = new ConcurrentHashMap(16, 0.75f, 64);
    private String contextPath = "";
    private static final Logger logger = Grizzly.logger(ServletContextImpl.class);
    private String basePath = "";
    private String contextName = "";
    private volatile String serverInfo = "Grizzly " + Grizzly.getDotedVersion();
    private ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private DispatcherHelper dispatcherHelper;

    protected void initListeners(List<String> listeners) {
        for (String listenerClass : listeners) {
            try {
                EventListener el = (EventListener)Thread.currentThread().getContextClassLoader().loadClass(listenerClass).newInstance();
                this.eventListeners.add(el);
            }
            catch (Throwable e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTEXT_LISTENER_LOAD_ERROR((Object)listenerClass), e);
            }
        }
        ServletContextEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners.get(i);
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextInitialized(event);
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR((Object)"contextInitialized", (Object)"ServletContextListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    protected void destroyListeners() {
        ServletContextEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners.get(i);
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextDestroyed(event);
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR((Object)"contextDestroyed", (Object)"ServletContextListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk uriDC = dd.uriDC;
        MappingData mappingData = dd.mappingData;
        try {
            uriDC.setString(uri);
            this.dispatcherHelper.mapPath(dd.hostDC, uriDC, mappingData);
            if (mappingData.context == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        if (!(mappingData.context instanceof ServletHandler)) {
            return null;
        }
        ServletHandler context = (ServletHandler)((Object)mappingData.context);
        return context.getServletCtx();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return MimeType.get((String)extension);
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        File[] files = new File(this.basePath, path).listFiles();
        HashSet<String> list = new HashSet<String>();
        if (files != null) {
            for (File f : files) {
                try {
                    String canonicalPath = f.getCanonicalPath();
                    if (f.isDirectory()) {
                        canonicalPath = canonicalPath + "/";
                    }
                    canonicalPath = canonicalPath.substring(canonicalPath.indexOf(this.basePath) + this.basePath.length());
                    list.add(canonicalPath.replace("\\", "/"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return list;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        if (path.length() > 1) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        if (path.length() > 1) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        if (!path.startsWith("/") && !path.isEmpty()) {
            throw new IllegalArgumentException("Path " + path + " does not start with ''/'' and is not empty");
        }
        String queryString = null;
        int pos = path.indexOf(63);
        if (pos >= 0) {
            queryString = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk uriDC = dd.uriDC;
        MappingData mappingData = dd.mappingData;
        try {
            uriDC.setString(this.contextPath + path);
            this.dispatcherHelper.mapPath(dd.hostDC, uriDC, mappingData);
            if (mappingData.wrapper == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        if (!(mappingData.wrapper instanceof ServletHandler)) {
            return null;
        }
        ServletHandler wrapper = (ServletHandler)((Object)mappingData.wrapper);
        String wrapperPath = mappingData.wrapperPath.toString();
        String pathInfo = mappingData.pathInfo.toString();
        return new RequestDispatcherImpl(wrapper, uriDC.toString(), wrapperPath, pathInfo, queryString, null);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk servletNameDC = dd.servletNameDC;
        MappingData mappingData = dd.mappingData;
        servletNameDC.setString(name);
        try {
            this.dispatcherHelper.mapName(servletNameDC, mappingData);
            if (!(mappingData.wrapper instanceof ServletHandler)) {
                return null;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        ServletHandler wrapper = (ServletHandler)((Object)mappingData.wrapper);
        return new RequestDispatcherImpl(wrapper, null, null, null, null, name);
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return new Enumerator((Collection)Collections.EMPTY_LIST);
    }

    public Enumeration getServletNames() {
        return new Enumerator((Collection)Collections.EMPTY_LIST);
    }

    public void log(String string) {
        logger.log(Level.INFO, string);
    }

    public void log(Exception e, String msg) {
        logger.log(Level.INFO, msg, e);
    }

    public void log(String msg, Throwable t) {
        logger.log(Level.INFO, msg, t);
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        return new File(this.basePath, path).getAbsolutePath();
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    protected void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getInitParameter(String name) {
        return this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new Enumerator((Collection)this.parameters.keySet());
    }

    protected void setInitParameter(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator((Collection)this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = this.attributes.put(name, value);
        ServletContextAttributeEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners.get(i);
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletContextAttributeEvent((ServletContext)this, name, oldValue) : new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR((Object)"ServletContextAttributeListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public void removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        if (value == null) {
            return;
        }
        ServletContextAttributeEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners.get(i);
            try {
                if (event == null) {
                    event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR((Object)"ServletContextAttributeListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public String getServletContextName() {
        return this.contextName;
    }

    public void setDisplayName(String contextName) {
        this.contextName = contextName;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    protected List<EventListener> getListeners() {
        return this.eventListeners;
    }

    protected void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.dispatcherHelper = dispatcherHelper;
    }

    private static final class DispatchData {
        public final DataChunk hostDC = DataChunk.newInstance();
        public final DataChunk uriDC = DataChunk.newInstance();
        public final DataChunk servletNameDC = DataChunk.newInstance();
        public final MappingData mappingData = new MappingData();

        public void recycle() {
            this.hostDC.recycle();
            this.uriDC.recycle();
            this.servletNameDC.recycle();
            this.mappingData.recycle();
        }
    }
}

