/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.integration.test.tests;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.integration.test.LeafBean;
import org.glassfish.hk2.xml.integration.test.RootBean;
import org.glassfish.hk2.xml.integration.test.tests.LeafBeanService;
import org.glassfish.hk2.xml.integration.test.tests.LeafMapService;
import org.glassfish.hk2.xml.integration.test.utilities.IntegrationTestUtilities;
import org.junit.Assert;
import org.junit.Test;

public class XmlIntegrationTest {
    private static final String NAME_KEY = "name";
    private static final String ALICE = "Alice";
    private static final String HATTER = "Hatter";

    @Test
    public void testHk2IntegrationMap() {
        ServiceLocator locator = IntegrationTestUtilities.createDomLocator(LeafMapService.class);
        this.createBenchmarkRoot(locator);
        List leaves = locator.getAllServices(LeafMapService.class, new Annotation[0]);
        Assert.assertEquals((long)2L, (long)leaves.size());
        LeafMapService aliceLeaf = (LeafMapService)leaves.get(0);
        Map<String, Object> aliceBean = aliceLeaf.getLeafAsMap();
        Assert.assertNotNull(aliceBean);
        Assert.assertEquals((Object)ALICE, (Object)aliceBean.get(NAME_KEY));
        LeafMapService hatterLeaf = (LeafMapService)leaves.get(1);
        Map<String, Object> hatterBean = hatterLeaf.getLeafAsMap();
        Assert.assertNotNull(hatterBean);
        Assert.assertEquals((Object)HATTER, (Object)hatterBean.get(NAME_KEY));
    }

    @Test
    public void testHk2IntegrationBean() {
        ServiceLocator locator = IntegrationTestUtilities.createLocator(LeafBeanService.class);
        this.createBenchmarkRoot(locator);
        List leaves = locator.getAllServices(LeafBeanService.class, new Annotation[0]);
        Assert.assertEquals((long)2L, (long)leaves.size());
        LeafBeanService aliceLeaf = (LeafBeanService)leaves.get(0);
        LeafBean aliceBean = aliceLeaf.getBeanAsBean();
        Assert.assertNotNull((Object)aliceBean);
        Assert.assertEquals((Object)ALICE, (Object)aliceBean.getName());
        LeafBeanService hatterLeaf = (LeafBeanService)leaves.get(1);
        LeafBean hatterBean = hatterLeaf.getBeanAsBean();
        Assert.assertNotNull((Object)hatterBean);
        Assert.assertEquals((Object)HATTER, (Object)hatterBean.getName());
    }

    private XmlRootHandle<RootBean> createBenchmarkRoot(ServiceLocator locator) {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle retVal = xmlService.createEmptyHandle(RootBean.class);
        retVal.addRoot();
        RootBean root = (RootBean)retVal.getRoot();
        root.addLeave(ALICE);
        root.addLeave(HATTER);
        return retVal;
    }
}

