/*
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.scripting.rails.sniffer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Which;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * JRuby sniffer
 *
 * @author Vivek Pandey
 */
@Service(name = "rails")
@Scoped(Singleton.class)
public class RailsSniffer implements Sniffer {

    @Inject
    Habitat habitat;

    @Inject
    ModulesRegistry registry;


    private final String containerName = "jruby";
    private final String APPLICATION = "app/controllers/application.rb";
    private final String BOOT= "config/boot.rb";
    private final String ENVIRONMENT = "config/environment.rb";
            
    private final String[] containers = {"org.glassfish.scripting.rails.RailsContainer"};

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        try {
            if (location.exists(APPLICATION) || location.exists(BOOT) || location.exists(ENVIRONMENT)) {
                return true;
            }
        } catch (IOException e) {
            // ignore
        }
        return false;
    }

    public String[] getURLPatterns() {
        //Rails applications dont have any specific patterns
        return null;
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    public String getModuleType() {
        return containerName;
    }

    /**
     * Sets up the container libraries so that any imported bundle from the
     * connector jar file will now be known to the module subsystem
     * <p/>
     * This method returns a {@link ModuleDefinition} for the module containing
     * the core implementation of the container. That means that this module
     * will be locked as long as there is at least one module loaded in the
     * associated container.
     *
     * @param containerHome is where the container implementation resides
     * @param logger        the logger to use
     * @return the module definition of the core container implementation.
     * @throws java.io.IOException exception if something goes sour
     */
    public Module[] setup(String containerHome, Logger logger) throws IOException {
        File rootLocation = new File(containerHome);
        if (!rootLocation.exists()) {
            throw new RuntimeException(Messages.format(Messages.JRUBY_HOME_NOTFOUND, rootLocation.getPath(),
                    System.getProperty("com.sun.aas.installRoot")+File.separator +"domains"+ File.separator+"domain1"+
                            File.separator+"config"+ File.separator+"domain.xml"));
        }

        Module grizzlyRails = registry.makeModuleFor("org.glassfish.scripting.grizzly-jruby-module", null);
        if (grizzlyRails==null) {
            String msg = Messages.format(Messages.JRUBY_MODULE_NOTFOUND, Which.jarFile(getClass()).toURI().toString());
            logger.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }

        return new Module[]{ grizzlyRails };
    }

    public void tearDown() {

    }

    public String[] getContainersNames() {
        return containers;
    }


    /**
     * @return whether this sniffer should be visible to user
     */
    public boolean isUserVisible() {
        return true;
    }

    public Map<String, String> getDeploymentConfigurations(ReadableArchive readableArchive) throws IOException {
        return Collections.EMPTY_MAP;
    }

}
