/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageExchangeHelper;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;

public class JAXRPCMessageProcessor
extends MessageProcessor {
    protected static final Logger logger = LogDomains.getLogger(JAXRPCMessageProcessor.class, (String)"javax.enterprise.system.container.ejb");

    public void process() {
        this.execute();
    }

    public void doWork() {
        try {
            MessageExchange me = this.getMessageExchange();
            String endpoint = me.getEndpoint().getEndpointName();
            QName service = me.getEndpoint().getServiceName();
            SOAPMessage response = null;
            MessageExchangeHelper meHelper = new MessageExchangeHelper();
            meHelper.setMessageExchange(me);
            try {
                this.debug(Level.FINEST, "serviceengine.process_incoming_request", new Object[]{service.getLocalPart(), endpoint});
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "serviceengine.error_incoming_request", e);
                ServiceEngineException seException = new ServiceEngineException(e);
                meHelper.handleException(seException);
            }
            meHelper.handleResponse(response, false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "JavaEEServiceEngine : Error processing request" + e, e);
        }
    }

    private void debug(Level logLevel, String msgID, Object[] params) {
        logger.log(logLevel, msgID, params);
    }
}

