/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.jbi.serviceengine.core.JBIEndpointManager;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineRuntimeHelper;
import com.sun.enterprise.jbi.serviceengine.util.JBIConstants;
import com.sun.enterprise.jbi.serviceengine.util.LocalDeploymentFacility;
import com.sun.enterprise.jbi.serviceengine.util.Util;
import com.sun.enterprise.jbi.serviceengine.util.soap.WSDLConverter;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.enterprise.deploy.spi.Target;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.client.DFDeploymentProperties;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.common.ModuleExploder;

public class JavaEEServiceEngineSUManager
implements ServiceUnitManager,
JBIConstants {
    protected static final Logger logger = LogDomains.getLogger(JavaEEServiceEngineSUManager.class, (String)"javax.enterprise.system.tools.deployment");
    private ServiceEngineRuntimeHelper runtimeHelper;
    private String className = "JavaEEServiceEngineSUManager :: ";
    private DeploymentFacility deployer;
    private String target = "server";
    private JBIEndpointManager epManager;
    private Set<String> dummyCompApps;

    public JavaEEServiceEngineSUManager() {
        this.createDeployer();
        this.epManager = new JBIEndpointManager();
        this.dummyCompApps = new HashSet<String>();
        this.runtimeHelper = ServiceEngineRuntimeHelper.getRuntime();
    }

    public void init(String suId, String suPath) throws DeploymentException {
        String methodSig = this.className + "init(String, String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId + ". suPath = " + suPath);
        try {
            if (this.isDummyApp(suPath)) {
                this.dummyCompApps.add(suId);
            }
            this.epManager.storeAllEndpoints(suPath, suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        if (this.isDAS() && !this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or start is done through" + " private MBean, hence skipping start.");
            this.doStart(suId, this.target);
        }
        try {
            this.epManager.startAllEndpoints(suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void shutDown(String suId) throws DeploymentException {
        String methodSig = this.className + "shutDown(String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId);
        try {
            this.dummyCompApps.remove(suId);
            this.epManager.removeAllEndpoints(suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public String deploy(String suId, String suPath) throws DeploymentException {
        String methodSig = this.className + "deploy(String, String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId + ". suPath = " + suPath);
        if (!this.isDAS() || this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or deployment is done " + "through private MBean, hence skipping deploy.");
            return Util.buildManagementMessage("STATUS_MSG", "deploy", "SUCCESS", null, suId, null, null);
        }
        return this.doDeploy(suId, suPath, this.target);
    }

    public String undeploy(String suId, String suPath) throws DeploymentException {
        String methodSig = this.className + "undeploy(String, String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId + ". suPath = " + suPath);
        if (!this.isDAS() || this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or undeployment is done" + " through private MBean, hence skipping undeploy.");
            return Util.buildManagementMessage("STATUS_MSG", "undeploy", "SUCCESS", null, suId, null, null);
        }
        return this.doUnDeploy(suId, this.target);
    }

    public void start(String suId) throws DeploymentException {
        String methodSig = this.className + "start(String) :: NO-OP";
        logger.log(Level.FINE, methodSig + " suId = " + suId);
    }

    public void stop(String suId) throws DeploymentException {
        String methodSig = this.className + "stop(String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId);
        if (this.isDAS() && !this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or deployment is done " + "through private MBean, hence skipping stop.");
            this.doStop(suId, this.target);
        }
        try {
            this.epManager.stopAllEndpoints(suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected String doDeploy(String serviceUnitName, String appLocation, String target) {
        String methodSig = this.className + "doDeploy(String,String,String,String) ";
        boolean deploymentSuccessful = true;
        String deploymentError = null;
        Throwable deploymentException = null;
        String archivePath = null;
        URI arch = null;
        URI plan = null;
        try {
            if (!this.isDummyApp(appLocation)) {
                if (!"nonsoapwsdl".equalsIgnoreCase(System.getProperty("com.sun.enterprise.jbi.se.usedwith"))) {
                    appLocation = this.processWSDLs(appLocation);
                }
                archivePath = new File(appLocation).isDirectory() ? this.createArchive(appLocation, serviceUnitName) : appLocation;
                logger.log(Level.FINE, methodSig + " appName = " + serviceUnitName + ", archivePath = " + archivePath + ", target = " + target);
                Map deployOptions = this.getDefaultDeploymentOptions(archivePath, serviceUnitName, target);
                arch = new File(archivePath).toURI();
                Target[] targets = this.deployer.createTargets(new String[]{target});
                logger.log(Level.FINE, methodSig + " calling backend deploy");
                DFProgressObject progressObject = this.deployer.deploy(targets, arch, plan, deployOptions);
                DFDeploymentStatus status = this.deployer.waitFor(progressObject);
                logger.log(Level.FINE, methodSig + " deployment complete. status = " + status.getStatus());
                if (status.getStatus() != DFDeploymentStatus.Status.SUCCESS) {
                    deploymentSuccessful = false;
                    deploymentError = methodSig + status.toString();
                    deploymentException = status.getStageException();
                }
            } else {
                this.dummyCompApps.add(serviceUnitName);
            }
        }
        catch (Exception ex) {
            deploymentSuccessful = false;
            deploymentError = methodSig + ex.getMessage();
            deploymentException = ex;
        }
        if (archivePath != null && new File(appLocation).isDirectory()) {
            try {
                boolean deleteSuccessful = new File(archivePath).delete();
                if (!deleteSuccessful) {
                    logger.log(Level.SEVERE, "Unable to delete the archive " + archivePath);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (deploymentSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully deployed " + serviceUnitName);
            return Util.buildManagementMessage("STATUS_MSG", "deploy", "SUCCESS", null, serviceUnitName, null, null);
        }
        logger.log(Level.SEVERE, deploymentError, deploymentException);
        return Util.buildManagementMessage("EXCEPTION_MSG", "deploy", "FAILED", null, serviceUnitName, deploymentError, deploymentException);
    }

    protected String doUnDeploy(String serviceUnitName, String target) {
        String methodSig = this.className + "doUnDeploy(String,String,String) ";
        boolean undeploymentSuccessful = true;
        String undeploymentError = null;
        Throwable undeploymentException = null;
        try {
            Target[] targets;
            DFProgressObject progressObject;
            DFDeploymentStatus status;
            if (!this.dummyCompApps.remove(serviceUnitName) && (status = this.deployer.waitFor(progressObject = this.deployer.undeploy(targets = this.deployer.createTargets(new String[]{target}), serviceUnitName, this.getUnDeploymentOptions()))).getStatus() != DFDeploymentStatus.Status.SUCCESS) {
                undeploymentSuccessful = false;
                undeploymentError = methodSig + status.toString();
                undeploymentException = status.getStageException();
            }
        }
        catch (Exception ex) {
            undeploymentSuccessful = false;
            undeploymentError = methodSig + ex.getMessage();
            undeploymentException = ex;
        }
        if (undeploymentSuccessful) {
            this.runtimeHelper.getEndpointInfoCollector().removeEndpoints(serviceUnitName);
            logger.log(Level.FINE, methodSig + " successfully undeployed " + serviceUnitName);
            return Util.buildManagementMessage("STATUS_MSG", "undeploy", "SUCCESS", null, serviceUnitName, null, null);
        }
        logger.log(Level.SEVERE, undeploymentError, undeploymentException);
        return Util.buildManagementMessage("EXCEPTION_MSG", "undeploy", "FAILED", null, serviceUnitName, undeploymentError, undeploymentException);
    }

    protected void doStart(String serviceUnitName, String target) {
        String methodSig = this.className + "doStart(String,String) ";
        boolean startSuccessful = true;
        String startError = null;
        Throwable startException = null;
        try {
            Target[] targets;
            DFProgressObject progressObject;
            DFDeploymentStatus status;
            if (!this.dummyCompApps.contains(serviceUnitName) && (status = this.deployer.waitFor(progressObject = this.deployer.enable(targets = this.deployer.createTargets(new String[]{target}), serviceUnitName))).getStatus() != DFDeploymentStatus.Status.SUCCESS) {
                startSuccessful = false;
                startError = methodSig + status.toString();
                startException = status.getStageException();
            }
        }
        catch (Exception ex) {
            startSuccessful = false;
            startError = methodSig + ex.getMessage();
            startException = ex;
        }
        if (startSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully started " + serviceUnitName);
        } else {
            logger.log(Level.SEVERE, startError, startException);
        }
    }

    protected void doStop(String serviceUnitName, String target) {
        String methodSig = this.className + "doStop(String,String) ";
        boolean stopSuccessful = true;
        String stopError = null;
        Throwable stopException = null;
        try {
            Target[] targets;
            DFProgressObject progressObject;
            DFDeploymentStatus status;
            if (!this.dummyCompApps.contains(serviceUnitName) && (status = this.deployer.waitFor(progressObject = this.deployer.disable(targets = this.deployer.createTargets(new String[]{target}), serviceUnitName))).getStatus() != DFDeploymentStatus.Status.SUCCESS) {
                stopSuccessful = false;
                stopError = methodSig + status.toString();
                stopException = status.getStageException();
            }
        }
        catch (Exception ex) {
            stopSuccessful = false;
            stopError = methodSig + ex.getMessage();
            stopException = ex;
        }
        if (stopSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully stopped " + serviceUnitName);
        } else {
            logger.log(Level.SEVERE, stopError, stopException);
        }
    }

    private String createArchive(String dir, String archiveName) throws URISyntaxException {
        String archivePath;
        ReadableArchive sourceArchive = null;
        try {
            File f = new File(dir);
            sourceArchive = this.runtimeHelper.getArchiveFactory().openArchive(f);
            Archivist archivist = this.runtimeHelper.getArchivistFactory().getArchivist(sourceArchive, this.getClass().getClassLoader());
            XModuleType moduleType = archivist.getModuleType();
            String pathExtn = ".jar";
            if (XModuleType.EAR.equals((Object)moduleType)) {
                pathExtn = ".ear";
            } else if (XModuleType.WAR.equals((Object)moduleType)) {
                pathExtn = ".war";
            } else if (XModuleType.RAR.equals((Object)moduleType)) {
                pathExtn = ".rar";
            }
            String workspaceDir = JavaEEServiceEngineContext.getInstance().getJBIContext().getWorkspaceRoot();
            archivePath = workspaceDir + File.separator + archiveName + pathExtn;
            if (XModuleType.EAR.equals((Object)moduleType)) {
                this.createEar(dir, archivePath);
            } else {
                this.createJar(dir, archivePath);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            archivePath = null;
        }
        return archivePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(String sourcePath, String destinationPath) throws IOException {
        File sourceFile = new File(sourcePath);
        File destFile = new File(destinationPath);
        FileArchive source = new FileArchive();
        OutputJarArchive destination = (OutputJarArchive)this.runtimeHelper.getHabitat().getComponent(OutputJarArchive.class);
        try {
            source.open(sourceFile.toURI());
            Enumeration entries = source.entries();
            destination.create(destFile.toURI());
            while (entries.hasMoreElements()) {
                String entry = (String)String.class.cast(entries.nextElement());
                InputStream is = null;
                OutputStream os = null;
                try {
                    is = source.getEntry(entry);
                    os = destination.putNextEntry(entry);
                    ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    destination.closeEntry();
                }
            }
        }
        finally {
            source.close();
            destination.close();
        }
    }

    private void createEar(String explodedDir, String earFilePath) throws Exception {
        ApplicationArchivist archivist = (ApplicationArchivist)this.runtimeHelper.getHabitat().getComponent(ApplicationArchivist.class);
        FileArchive appArchive = new FileArchive();
        appArchive.open(new File(explodedDir).toURI());
        archivist.setManifest(appArchive.getManifest());
        Application application = null;
        if (archivist.hasStandardDeploymentDescriptor((ReadableArchive)appArchive)) {
            application = (Application)archivist.readStandardDeploymentDescriptor((ReadableArchive)appArchive);
        }
        archivist.setDescriptor(application);
        Set modules = application.getModules();
        for (ModuleDescriptor bundle : modules) {
            String moduleName = bundle.getArchiveUri();
            String massagedModuleName = FileUtils.makeFriendlyFilename((String)moduleName);
            String explodedModulePath = explodedDir + File.separator + massagedModuleName;
            String moduleArhivePath = explodedDir + File.separator + moduleName;
            this.createJar(explodedModulePath, moduleArhivePath);
            this.deleteDirectory(new File(explodedModulePath));
        }
        this.createJar(explodedDir, earFilePath);
    }

    public void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File child = files[i];
                if (child.isDirectory()) {
                    this.deleteDirectory(child);
                }
                child.delete();
            }
        }
        dir.delete();
    }

    private void explodeArchive(String src, String dest) throws IOException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        if (destFile.exists()) {
            this.deleteDirectory(destFile);
            destFile.mkdir();
        }
        try {
            ReadableArchive sourceArchive = this.runtimeHelper.getArchiveFactory().openArchive(srcFile);
            Archivist archivist = this.runtimeHelper.getArchivistFactory().getArchivist(sourceArchive, this.getClass().getClassLoader());
            XModuleType moduleType = archivist.getModuleType();
            if (!XModuleType.EAR.equals((Object)moduleType) && (XModuleType.EJB.equals((Object)moduleType) || XModuleType.CAR.equals((Object)moduleType) || XModuleType.RAR.equals((Object)moduleType) || XModuleType.WAR.equals((Object)moduleType))) {
                ModuleExploder.explodeJar((File)srcFile, (File)destFile);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private Map getDefaultDeploymentOptions(String archivePath, String appName, String target) {
        DFDeploymentProperties deploymentOptions = new DFDeploymentProperties();
        deploymentOptions.setName(appName);
        deploymentOptions.setForce(true);
        deploymentOptions.setEnabled(false);
        deploymentOptions.setTarget(target);
        Properties props = new Properties();
        props.setProperty("externallyManaged", "true");
        deploymentOptions.setProperties(props);
        return deploymentOptions;
    }

    private Map getUnDeploymentOptions() {
        DFDeploymentProperties undeploymentOptions = new DFDeploymentProperties();
        return undeploymentOptions;
    }

    private boolean isPrivateMBeanRegistered() {
        return false;
    }

    private void createDeployer() {
        this.deployer = new LocalDeploymentFacility();
        ServerConnectionIdentifier scid = new ServerConnectionIdentifier();
        scid.setHostName("localhost");
        this.deployer.connect(scid);
    }

    private boolean isDAS() {
        return true;
    }

    private boolean isDummyApp(String appLocation) throws IOException {
        File app = new File(appLocation);
        if (app.isDirectory()) {
            for (Object fileObj : FileUtils.getAllFilesAndDirectoriesUnder((File)app)) {
                String path = ((File)fileObj).getPath();
                if (("META-INF" + File.separator + "jbi.xml").equalsIgnoreCase(path) || ("META-INF" + File.separator + "MANIFEST.MF").equalsIgnoreCase(path) || "META-INF".equalsIgnoreCase(path)) continue;
                return false;
            }
        } else {
            ZipFile zipFile = new ZipFile(appLocation);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                String entryName = e.nextElement().getName();
                if ("META-INF/jbi.xml".equalsIgnoreCase(entryName) || "META-INF/MANIFEST.MF".equalsIgnoreCase(entryName) || "META-INF/".equalsIgnoreCase(entryName)) continue;
                return false;
            }
        }
        return true;
    }

    private String processWSDLs(String appLocation) {
        String newAppLocation;
        if (!new File(appLocation).isDirectory()) {
            try {
                String workspaceDir = JavaEEServiceEngineContext.getInstance().getJBIContext().getWorkspaceRoot();
                newAppLocation = workspaceDir + File.separator + "exploded";
                this.explodeArchive(appLocation, newAppLocation);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return appLocation;
            }
        } else {
            newAppLocation = appLocation;
        }
        return WSDLConverter.convertWSDLs(newAppLocation).isEmpty() ? appLocation : newAppLocation;
    }
}

