/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.tools.verifier.Initializer;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.packageadmin.PackageAdmin;

@Service
public class VerifierModuleStartup
implements ModuleStartup {
    @Inject
    private Habitat habitat;
    @Inject
    private ModulesRegistry mr;
    @Inject
    PackageAdmin pa;
    @Inject
    Globals globals;
    private StartupContext startupContext;
    private int failedCount;
    private ClassLoader oldCL;

    public void setStartupContext(StartupContext context) {
        this.startupContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block10: {
            this.setTCL();
            try {
                this.registerFrameworkListener();
                String[] args = this.startupContext.getOriginalArguments();
                VerifierFrameworkContext verifierFrameworkContext = new Initializer(args).getVerificationContext();
                Verifier verifier = (Verifier)this.habitat.getComponent(Verifier.class);
                try {
                    verifier.init(verifierFrameworkContext);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (verifierFrameworkContext.isUsingGui()) {
                    MainFrame mf = new MainFrame(verifierFrameworkContext.getJarFileName(), true, verifier);
                    mf.setSize(800, 600);
                    mf.setVisible(true);
                    break block10;
                }
                LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
                try {
                    verifier.verify();
                }
                catch (Exception e) {
                    LogRecord logRecord = new LogRecord(Level.SEVERE, smh.getLocalString(verifier.getClass().getName() + ".verifyFailed", "Could not verify successfully."));
                    logRecord.setThrown(e);
                    verifierFrameworkContext.getResultManager().log(logRecord);
                }
                try {
                    verifier.generateReports();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.failedCount = verifierFrameworkContext.getResultManager().getFailedCount() + verifierFrameworkContext.getResultManager().getErrorCount();
            }
            finally {
                this.unsetTCL();
            }
        }
    }

    private void registerFrameworkListener() {
        final Bundle bundle = this.pa.getBundle(this.getClass());
        bundle.getBundleContext().addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                Bundle systemBundle = bundle.getBundleContext().getBundle(0L);
                switch (event.getType()) {
                    case 1: {
                        try {
                            systemBundle.stop();
                        }
                        catch (BundleException e) {
                            throw new RuntimeException(e);
                        }
                        System.out.println("Stopped " + systemBundle);
                        System.exit(VerifierModuleStartup.this.failedCount);
                        break;
                    }
                    case 2: {
                        try {
                            systemBundle.stop();
                            System.out.println("Stopped " + systemBundle);
                        }
                        catch (BundleException e) {
                            throw new RuntimeException(e);
                        }
                        System.exit(-1);
                    }
                }
            }
        });
    }

    public void stop() {
    }

    private void setTCL() {
        this.oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
    }

    private void unsetTCL() {
        Thread.currentThread().setContextClassLoader(this.oldCL);
    }
}

