/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.packaging;

import com.sun.enterprise.tools.verifier.apiscan.packaging.Archive;
import com.sun.enterprise.tools.verifier.apiscan.packaging.DeweyDecimal;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtensionRef {
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    public static final Logger logger = Logger.getLogger("apiscan.packaging", resourceBundleName);
    private static final String myClassName = "ExtensionRef";
    private String name;
    private String implVendorId = "";
    private String implVer;
    private DeweyDecimal specVer;

    public ExtensionRef(Manifest manifest, String extName) {
        Attributes attrs = manifest.getMainAttributes();
        this.name = attrs.getValue(extName + "-" + Attributes.Name.EXTENSION_NAME);
        String s = attrs.getValue(extName + "-" + Attributes.Name.SPECIFICATION_VERSION);
        if (s != null) {
            try {
                this.specVer = new DeweyDecimal(s);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, this.getClass().getName() + ".exception1", new Object[]{e.getMessage()});
                logger.log(Level.SEVERE, "", e);
                throw e;
            }
        }
        this.implVendorId = attrs.getValue(extName + "-" + Attributes.Name.IMPLEMENTATION_VENDOR_ID);
        this.implVer = attrs.getValue(extName + "-" + Attributes.Name.IMPLEMENTATION_VERSION);
        this.validate();
    }

    private void validate() {
        if (this.name == null || this.name.length() <= 0) {
            throw new IllegalArgumentException("Extension-Name can not be empty.");
        }
    }

    public boolean isSatisfiedBy(Archive another) throws IOException {
        logger.entering(myClassName, "isSatisfiedBy", another);
        Attributes attrs = another.getManifest().getMainAttributes();
        String name = attrs.getValue(Attributes.Name.EXTENSION_NAME);
        String s = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
        DeweyDecimal specVer = null;
        try {
            specVer = s != null ? new DeweyDecimal(s) : null;
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, this.getClass().getName() + ".warning1", new Object[]{e.getMessage(), another.toString()});
            return false;
        }
        String implVendorId = attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
        String implVer = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        return !(!this.name.equals(name) || this.specVer != null && !this.specVer.isCompatible(specVer) || this.implVendorId != null && !this.implVendorId.equals(implVendorId) || this.implVer != null && !this.implVer.equals(implVer));
    }

    public String toString() {
        return "Extension-Name: " + this.name + "\n" + (this.specVer != null ? "Specification-Version: " + this.specVer + "\n" : "") + (this.implVendorId != null ? "Implementation-Vendor-Id: " + this.implVendorId + "\n" : "") + (this.implVer != null ? "Implementation-Version: " + this.implVer + "\n" : "");
    }
}

