/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;

public class SessionSynchronizationInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionType();
            try {
                Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                block2: do {
                    for (Class<?> interfaces : c.getInterfaces()) {
                        this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces.getName()});
                        if (!interfaces.getName().equals("javax.ejb.SessionSynchronization")) continue;
                        String transactionType = descriptor.getTransactionType();
                        if (!"Stateless".equals(stateType) && (!"Stateful".equals(stateType) || !"Bean".equals(transactionType))) continue;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface must not be implemented by a stateless Session Bean. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                        continue block2;
                    }
                } while ((c = c.getSuperclass()) != null);
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The required interface is properly implemented"));
        }
        return result;
    }
}

