/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.io.DescriptorConstants;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AppClientPublicID
extends AppClientTest
implements AppClientCheck {
    String[] acceptablePubidLiterals = new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN", "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN"};
    String[] acceptableURLs = new String[]{"http://java.sun.com/j2ee/dtds/application-client_1_2.dtd", "http://java.sun.com/dtd/application-client_1_3.dtd"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getSpecVersion().compareTo("1.4") < 0) {
            InputStream deploymentEntry = null;
            BufferedReader in = null;
            String uri = null;
            try {
                uri = this.getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry(DescriptorConstants.APP_CLIENT_DD_ENTRY);
                if (deploymentEntry == null) return result;
                in = new BufferedReader(new InputStreamReader(deploymentEntry));
                String s = in.readLine();
                boolean foundDOCTYPE = false;
                boolean foundPubid = false;
                boolean foundURL = false;
                while (s != null) {
                    if (s.indexOf("DOCTYPE") > -1) {
                        foundDOCTYPE = true;
                    }
                    if (foundDOCTYPE) {
                        for (int i = 0; i < this.acceptablePubidLiterals.length; ++i) {
                            if (s.indexOf(this.acceptablePubidLiterals[i]) > -1) {
                                foundPubid = true;
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The deployment descriptor has the proper PubidLiteral: {0}", new Object[]{this.acceptablePubidLiterals[i]}));
                            }
                            if (s.indexOf(this.acceptableURLs[i]) <= -1) continue;
                            foundURL = true;
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "The deployment descriptor has the proper URL corresponding the the PubIdLiteral: {0}", new Object[]{this.acceptableURLs[i]}));
                        }
                    }
                    if (foundPubid && foundURL) {
                        result.setStatus(0);
                        break;
                    }
                    if (foundDOCTYPE && s.endsWith(">")) break;
                    s = in.readLine();
                }
                if (!foundDOCTYPE) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "No document type declaration found in the deployment descriptor for {0}", new Object[]{descriptor.getName()}));
                    return result;
                }
                if (!foundPubid) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "The deployment descriptor for {0} does not have an expected PubidLiteral ", new Object[]{descriptor.getName()}));
                    return result;
                }
                if (foundURL) return result;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The deployment descriptor {0} doesnot have the right URL corresponding to the PubIdLiteral", new Object[]{descriptor.getName()}));
                return result;
            }
            catch (IOException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".IOException", "I/O error trying to open {0}", new Object[]{uri}));
                return result;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (deploymentEntry != null) {
                        deploymentEntry.close();
                    }
                }
                catch (Exception x) {}
            }
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT-APPLICABLE: No DOCTYPE found for [ {0} ]", new Object[]{descriptor.getName()}));
        return result;
    }
}

