/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.util.io.FileUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public abstract class ConnectorTest
extends VerifierTest
implements VerifierCheck,
ConnectorCheck {
    public Result check(Descriptor descriptor) {
        return this.check((ConnectorDescriptor)descriptor);
    }

    public abstract Result check(ConnectorDescriptor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findImplementorOf(ConnectorDescriptor desc, String interfaceName) {
        try {
            String uri = this.getAbstractArchiveUri(desc);
            FileArchive arch = new FileArchive();
            arch.open(uri);
            Enumeration en = arch.entries();
            block20: while (en.hasMoreElements()) {
                String entry = (String)en.nextElement();
                if (!entry.endsWith(".jar")) continue;
                JarInputStream jis = new JarInputStream(arch.getEntry(entry));
                try {
                    ZipEntry ze = jis.getNextEntry();
                    while (true) {
                        ClassLoader jcl;
                        String className;
                        Class<?> c;
                        if (ze == null) continue block20;
                        String elementName = ze.getName();
                        if (elementName.endsWith(".class") && ConnectorTest.isImplementorOf(c = Class.forName(className = elementName.substring(0, elementName.length() - ".class".length()).replace('/', '.'), false, jcl = this.getVerifierContext().getRarClassLoader()), interfaceName) && c.getSuperclass() != null) {
                            Class<?> clazz = c;
                            return clazz;
                        }
                        ze = jis.getNextEntry();
                    }
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (NoClassDefFoundError cdnf) {
                }
                finally {
                    try {
                        if (jis == null) continue;
                        jis.close();
                    }
                    catch (IOException e) {}
                }
            }
            return null;
        }
        catch (IOException ioe) {
            Verifier.debug(ioe);
        }
        return null;
    }

    protected boolean checkMethodImpl(Class clazz, String methodName, Class[] parmTypes, String methodSignature, Result result) {
        Method m = null;
        Class c = clazz;
        do {
            try {
                m = c.getDeclaredMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            c = c.getSuperclass();
        } while (m != null && c != null && c != Object.class);
        if (m == null) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.MethodOverride.failed", "Warning: The class [ {0} ] does not override the method [ {1} ]", new Object[]{clazz.getName(), methodSignature}));
            return false;
        }
        result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.MethodOverride.passed", "The class [ {0} ] overrides the method [ {1} ]", new Object[]{clazz.getName(), methodSignature}));
        return true;
    }

    protected boolean findImplementorOf(ConnectorDescriptor desc, String interfaceName, Result result) {
        Class c = this.findImplementorOf(desc, interfaceName);
        if (c != null) {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.passed", "The class [ {0} ] implements the [ {1} ] interface", new Object[]{c.getName(), interfaceName}));
            return true;
        }
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.failed", "Error: There is no implementation of the [ {0} ] provided", new Object[]{interfaceName}));
        return false;
    }

    protected boolean isClassLoadable(String className, Result result) {
        ClassLoader jcl = this.getVerifierContext().getClassLoader();
        try {
            Class.forName(className, false, jcl);
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.passed", "The class [ {0} ] is contained in the archive file", new Object[]{className}));
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{className}));
            return true;
        }
    }

    protected String getAbstractArchiveUri(ConnectorDescriptor desc) {
        String archBase = this.getVerifierContext().getAbstractArchive().getURI().toString();
        ModuleDescriptor moduleDescriptor = desc.getModuleDescriptor();
        if (moduleDescriptor.isStandalone()) {
            return archBase;
        }
        return archBase + "/" + FileUtils.makeFriendlyFilename((String)moduleDescriptor.getArchiveUri());
    }
}

