/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;

public class TransactionDemarcationHomeInterface
extends EjbTest
implements EjbCheck {
    static String[] EJBObjectMethods = new String[]{"getHomeHandle", "getEJBMetaData"};
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        try {
            if (descriptor instanceof EjbEntityDescriptor) {
                if (descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
                    this.addNaDetails(this.result, this.compName);
                    this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "There is no home interface specified for [ {0} ]", new Object[]{descriptor.getName()}));
                    return this.result;
                }
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor, "Home");
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.addNaDetails(this.result, this.compName);
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
            return this.result;
        }
        catch (Throwable t) {
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface does not contain class [ {0} ] within bean [ {1} ]", new Object[]{t.getMessage(), descriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor, String methodIntf) {
        boolean oneFailed = false;
        try {
            Arrays.sort(EJBObjectMethods);
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Method[] methods = c.getDeclaredMethods();
            boolean lookForIt = false;
            for (int i = 0; i < methods.length; ++i) {
                if (Arrays.binarySearch(EJBObjectMethods, methods[i].getName()) < 0) {
                    try {
                        ContainerTransaction containerTransaction = null;
                        boolean resolved = false;
                        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                            Enumeration ee = descriptor.getMethodContainerTransactions().keys();
                            while (ee.hasMoreElements()) {
                                lookForIt = false;
                                MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
                                lookForIt = methodDescriptor.getName().equals("*") ? (methodDescriptor.getEjbClassSymbol() == null ? true : (methodDescriptor.getEjbClassSymbol().equals("Home") ? true : (methodDescriptor.getEjbClassSymbol().equals("") ? true : (methodDescriptor.getEjbClassSymbol().equals("LocalHome") ? true : (methodDescriptor.getEjbClassSymbol().equals("Remote") ? false : (methodDescriptor.getEjbClassSymbol().equals("Local") ? false : false)))))) : (methodDescriptor.getParameterClassNames() == null ? (methodDescriptor.getEjbClassSymbol() == null || methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals("Home") || methodDescriptor.getEjbClassSymbol().equals("LocalHome")) && methods[i].getName().equals(methodDescriptor.getName()) : (methodDescriptor.getEjbClassSymbol() == null || methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals("Home") || methodDescriptor.getEjbClassSymbol().equals("LocalHome")) && methods[i].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(methods[i], methodIntf).getParameterClassNames()));
                                if (!lookForIt) continue;
                                containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                                if (containerTransaction != null) {
                                    String transactionAttribute = containerTransaction.getTransactionAttribute();
                                    if ("NotSupported".equals(transactionAttribute) || "Supports".equals(transactionAttribute) || "Required".equals(transactionAttribute) || "RequiresNew".equals(transactionAttribute) || "Mandatory".equals(transactionAttribute) || "Never".equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                        this.addGoodDetails(this.result, this.compName);
                                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: [ {0} ] TransactionAttribute [ {1} ] for method [ {2} ] is valid.   Transaction attributes must be specified for all methods except getEJBMetaData and getHomeHandle methods of home interface [ {3} ]", new Object[]{methods[i].getName(), transactionAttribute, methodDescriptor.getName(), home}));
                                        resolved = true;
                                        continue;
                                    }
                                    oneFailed = true;
                                    this.addErrorDetails(this.result, this.compName);
                                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] TransactionAttribute [ {1} ] for method [ {2} ] is not valid.   Transaction attributes must be specified for all methods except getEJBMetaData and getHomeHandle methods of home interface [ {3} ]", new Object[]{methods[i].getName(), transactionAttribute, methodDescriptor.getName(), home}));
                                    continue;
                                }
                                oneFailed = true;
                                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                            }
                            if (!resolved) {
                                oneFailed = true;
                                this.addErrorDetails(this.result, this.compName);
                                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Transaction attributes must be specified for the methods defined in the home interface [ {0} ].  Method [ {1} ] has no transaction attribute defined within this bean [ {2} ].", new Object[]{home, methods[i].getName(), descriptor.getName()}));
                            }
                        } else {
                            oneFailed = true;
                            this.addErrorDetails(this.result, this.compName);
                            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: There are no method container transactions within this bean [ {0} ].   Transaction attributes must be specified for the methods defined in the home interface [ {1} ].  Method [ {2} ] has no transaction attribute defined.", new Object[]{descriptor.getName(), home, methods[i].getName()}));
                        }
                        if (!oneFailed || i != methods.length - 1) continue;
                        return oneFailed;
                    }
                    catch (Exception e) {
                        this.addErrorDetails(this.result, this.compName);
                        this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{home, e.getMessage(), descriptor.getName()}));
                        oneFailed = true;
                        return oneFailed;
                    }
                }
                oneFailed = true;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedExcep", "Error: Method [ {0} ] should not be assigned a transaction attribute.", new Object[]{methods[i].getName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

