/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.ejb.EJBHome;

public abstract class HomeMethodTest
extends EjbTest {
    protected abstract String getHomeInterfaceName(EjbDescriptor var1);

    protected abstract String getSuperInterface();

    protected abstract void runIndividualHomeMethodTest(Method var1, EjbDescriptor var2, Result var3);

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (this.getHomeInterfaceName(descriptor) == null || "".equals(this.getHomeInterfaceName(descriptor))) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
            return result;
        }
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        boolean homeMethodFound = false;
        try {
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Vector<Method> v = new Vector<Method>();
            for (Class<?> homeInterfaceClass = Class.forName(this.getClassName(descriptor), false, jcl); homeInterfaceClass != null && !homeInterfaceClass.getName().equals(this.getSuperInterface()) && !homeInterfaceClass.getName().equals("java.lang.Object"); homeInterfaceClass = homeInterfaceClass.getSuperclass()) {
                Method[] homeInterfaceMethods = homeInterfaceClass.getDeclaredMethods();
                for (int i = 0; i < homeInterfaceMethods.length; ++i) {
                    v.add(homeInterfaceMethods[i]);
                }
            }
            for (Method method : v) {
                Method m;
                String methodName = method.getName();
                if (methodName.startsWith("create") || methodName.startsWith("find") || methodName.startsWith("remove") || (m = HomeMethodTest.getMethod(EJBHome.class, methodName, method.getParameterTypes())) != null) continue;
                homeMethodFound = true;
                this.runIndividualHomeMethodTest(method, descriptor, result);
                if (result.getStatus() != 1) continue;
                break;
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{this.getClassName(descriptor), descriptor.getName()}));
        }
        if (!homeMethodFound) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable2", "Home interface [ {0} ] does not define any home methods", new Object[]{this.getClassName(descriptor)}));
        }
        return result;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getHomeInterfaceName(descriptor);
    }
}

