/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class TransientFieldsSerialization
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean isEjb30 = descriptor.getEjbBundleDescriptor().getSpecVersion().equalsIgnoreCase("3.0");
        if (descriptor instanceof EjbSessionDescriptor) {
            try {
                Class<?> c = Class.forName(((EjbSessionDescriptor)descriptor).getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                Field[] fields = c.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Class<?> fc;
                    int modifiers = fields[i].getModifiers();
                    if (!Modifier.isTransient(modifiers) || !(fc = fields[i].getType()).getName().equals("javax.ejb.SessionContext") && !fc.getName().equals("javax.transaction.UserTransaction") && !fc.getName().equals(descriptor.getRemoteClassName()) && !fc.getName().equals(descriptor.getHomeClassName()) && !fc.getName().equals(descriptor.getLocalClassName()) && !fc.getName().equals(descriptor.getLocalHomeClassName()) && (!isEjb30 || !fc.getName().equals("javax.ejb.EntityManager")) && (!isEjb30 || !fc.getName().equals("javax.ejb.EntityManagerFactory"))) continue;
                    result.failed(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Field [ {0} ] defined within session bean class [ {1} ] is defined as transient. Session bean fields should not store in a transient field a reference to any of the following objects: SessionContext object; environment JNDI naming context and any its subcontexts; home and remote interfaces; and the UserTransaction interface.", new Object[]{fields[i].getName(), ((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "This session bean class has not stored in a transient field a reference to any of the following objects: SessionContext object; environment JNDI naming context and any its subcontexts; home and remote interfaces; and the UserTransaction interface."));
        }
        return result;
    }
}

