/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class StatelessEjbCreateHome
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionType();
            if ("Stateless".equals(stateType)) {
                try {
                    VerifierTestContext context = this.getVerifierContext();
                    ClassLoader jcl = context.getClassLoader();
                    Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                    Method m = null;
                    int foundThisManyTimes = 0;
                    do {
                        Method[] methods = c.getDeclaredMethods();
                        for (int i = 0; i < methods.length; ++i) {
                            if (!methods[i].getName().equals("ejbCreate")) continue;
                            if (foundThisManyTimes == 0) {
                                m = methods[i];
                                ++foundThisManyTimes;
                                continue;
                            }
                            ++foundThisManyTimes;
                        }
                    } while ((c = c.getSuperclass()) != null && m == null);
                    if (m != null && foundThisManyTimes == 1) {
                        Class<?>[] cc = m.getParameterTypes();
                        if (cc.length > 0) {
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The ejbCreate method has one or more parameters \nwithin bean [ {0} ].  Stateless session are only allowed \nto have ejbCreate methods with no arguments.", new Object[]{descriptor.getEjbClassName()}));
                        } else {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: This bean's [ {0} ] ejbCreate method has no parameters.\n Stateless session beans can only have a ejbCreate method\n with no parameters.", new Object[]{descriptor.getEjbClassName()}));
                        }
                    } else if (m != null && foundThisManyTimes > 1) {
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] ejbCreate methods exists within bean [ {1} ].  The EJB class must have only one ejbCreate method for stateless session bean. ", new Object[]{new Integer(foundThisManyTimes), descriptor.getEjbClassName()}));
                    } else {
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "Error: No ejbCreate method exists within bean [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e) {
                    Verifier.debug(e);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
                }
                return result;
            }
            if ("Stateful".equals(stateType)) {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "{0} expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), "Stateless", stateType}));
                return result;
            }
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

