/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.Tag;

public class TagClassExtendsValidInterface
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        VerifierTestContext context = this.getVerifierContext();
        Result result = this.loadWarFile(descriptor);
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        boolean failed = false;
        boolean oneFailed = false;
        if (tlds == null) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No tag lib files are specified"));
            return result;
        }
        for (TagLibDescriptor tld : tlds) {
            TagDescriptor[] tagDesc;
            for (TagDescriptor td : tagDesc = tld.getTagDescriptors()) {
                String tagclass = td.getTagClass();
                Class c = this.loadClass(result, tagclass);
                if (c == null) continue;
                if (tld.getSpecVersion().trim().equalsIgnoreCase("2.0")) {
                    failed = !JspTag.class.isAssignableFrom(c);
                } else {
                    boolean bl = failed = !Tag.class.isAssignableFrom(c);
                }
                if (failed) {
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: tag class [ {0} ] in [ {1} ] does not implements valid interface", new Object[]{c.getName(), tld.getUri()}));
                    continue;
                }
                this.addGoodDetails(result, compName);
                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "tag class [ {0} ] in [ {1} ] implements valid interface", new Object[]{c.getName(), tld.getUri()}));
            }
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

