/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.api;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.glowroot.agent.plugin.api.internal.ReadableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static final int MESSAGE_CHAR_LIMIT = Integer.getInteger("glowroot.message.char.limit", 524288);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final ImmutableMap<String, Object> EMPTY_DETAIL = ImmutableMap.of();

    public static Message create(@Nullable String message) {
        return new MessageImpl(message, EMPTY_ARGS, (Map)EMPTY_DETAIL);
    }

    public static Message create(String template, String ... args) {
        return new MessageImpl(template, args, (Map)EMPTY_DETAIL);
    }

    public static Message create(@Nullable String message, Map<String, ? extends Object> detail) {
        return new MessageImpl(message, EMPTY_ARGS, detail);
    }

    Message() {
    }

    private static class MessageImpl
    extends Message
    implements ReadableMessage {
        private static final Logger logger = LoggerFactory.getLogger(MessageImpl.class);
        @Nullable
        private final String template;
        @Nullable
        private final String[] args;
        private final Map<String, ? extends Object> detail;

        private MessageImpl(@Nullable String template, @Nullable String[] args, Map<String, ? extends Object> detail) {
            this.template = MessageImpl.truncateToMessageCharLimit(template);
            for (int i = 0; i < args.length; ++i) {
                args[i] = MessageImpl.truncateToMessageCharLimit(args[i]);
            }
            this.args = args;
            this.detail = detail;
        }

        @Override
        public String getText() {
            int next;
            if (this.template == null) {
                return "";
            }
            if (this.args.length == 0) {
                return this.template;
            }
            StringBuilder text = new StringBuilder();
            int curr = 0;
            int argIndex = 0;
            while ((next = this.template.indexOf("{}", curr)) != -1) {
                text.append(this.template.substring(curr, next));
                if (argIndex < this.args.length) {
                    text.append(this.args[argIndex++]);
                    curr = next + 2;
                    continue;
                }
                text.append("<not enough args provided for template>");
                curr = next + 2;
                logger.warn("not enough args provided for template: {}", (Object)this.template);
            }
            text.append(this.template.substring(curr));
            return MessageImpl.truncateToMessageCharLimit(text.toString());
        }

        @Override
        public Map<String, ? extends Object> getDetail() {
            return this.detail;
        }

        @PolyNull
        private static String truncateToMessageCharLimit(@PolyNull String s) {
            if (s == null || s.length() <= MESSAGE_CHAR_LIMIT) {
                return s;
            }
            return s.substring(0, MESSAGE_CHAR_LIMIT) + " [truncated to " + MESSAGE_CHAR_LIMIT + " characters]";
        }
    }
}

