/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.api;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.glowroot.agent.plugin.api.internal.ReadableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    private static final int MESSAGE_CHAR_LIMIT = Integer.getInteger("glowroot.message.char.limit", 100000);
    private static final int MESSAGE_DETAIL_CHAR_LIMIT = Integer.getInteger("glowroot.message.detail.char.limit", 10000);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final ImmutableMap<String, Object> EMPTY_DETAIL = ImmutableMap.of();

    public static Message create(@Nullable String message) {
        return new MessageImpl(message, EMPTY_ARGS, (Map)EMPTY_DETAIL);
    }

    public static Message create(String template, String ... args) {
        return new MessageImpl(template, args, (Map)EMPTY_DETAIL);
    }

    public static Message create(@Nullable String message, Map<String, ?> detail) {
        return new MessageImpl(message, EMPTY_ARGS, detail);
    }

    Message() {
    }

    private static class MessageImpl
    extends Message
    implements ReadableMessage {
        private static final Logger logger = LoggerFactory.getLogger(MessageImpl.class);
        @Nullable
        private final String template;
        @Nullable
        private final String[] args;
        private final Map<String, ?> detail;

        private MessageImpl(@Nullable String template, @Nullable String[] args, Map<String, ?> detail) {
            this.template = MessageImpl.truncateMessageIfNeeded(template);
            for (int i = 0; i < args.length; ++i) {
                args[i] = MessageImpl.truncateMessageIfNeeded(args[i]);
            }
            this.args = args;
            this.detail = MessageImpl.needsTruncateDetail(detail) ? MessageImpl.truncateDetail(detail) : detail;
        }

        @Override
        public String getText() {
            int next;
            if (this.template == null) {
                return "";
            }
            if (this.args.length == 0) {
                return this.template;
            }
            StringBuilder text = new StringBuilder();
            int curr = 0;
            int argIndex = 0;
            while ((next = this.template.indexOf("{}", curr)) != -1) {
                text.append(this.template.substring(curr, next));
                if (argIndex < this.args.length) {
                    text.append(this.args[argIndex++]);
                    curr = next + 2;
                    continue;
                }
                text.append("<not enough args provided for template>");
                curr = next + 2;
                logger.warn("not enough args provided for template: {}", (Object)this.template);
            }
            text.append(this.template.substring(curr));
            return MessageImpl.truncateMessageIfNeeded(text.toString());
        }

        @Override
        public Map<String, ?> getDetail() {
            return this.detail;
        }

        @PolyNull
        private static String truncateMessageIfNeeded(@PolyNull String s) {
            if (s == null || s.length() <= MESSAGE_CHAR_LIMIT) {
                return s;
            }
            return s.substring(0, MESSAGE_CHAR_LIMIT) + " [truncated to " + MESSAGE_CHAR_LIMIT + " characters]";
        }

        private static boolean needsTruncateDetail(Map<?, ?> detail) {
            for (Map.Entry<?, ?> entry : detail.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String && MessageImpl.needsTruncateDetail((String)key)) {
                    return true;
                }
                if (!MessageImpl.needsTruncateDetail(entry.getValue())) continue;
                return true;
            }
            return false;
        }

        private static boolean needsTruncateDetail(@Nullable Object value) {
            if (value instanceof Map) {
                return MessageImpl.needsTruncateDetail((Map)value);
            }
            if (value instanceof List) {
                return MessageImpl.needsTruncateDetail((List)value);
            }
            if (value instanceof Optional) {
                return MessageImpl.needsTruncateDetail((Optional)value);
            }
            if (value instanceof String) {
                return MessageImpl.needsTruncateDetail((String)value);
            }
            return false;
        }

        private static boolean needsTruncateDetail(List<?> detail) {
            for (Object value : detail) {
                if (!MessageImpl.needsTruncateDetail(value)) continue;
                return true;
            }
            return false;
        }

        private static boolean needsTruncateDetail(Optional<?> optional) {
            if (!optional.isPresent()) {
                return false;
            }
            Object value = optional.get();
            return value instanceof String && MessageImpl.needsTruncateDetail((String)value);
        }

        private static boolean needsTruncateDetail(String value) {
            return value.length() > MESSAGE_DETAIL_CHAR_LIMIT;
        }

        private static Map<String, ?> truncateDetail(Map<String, ?> detail) {
            HashMap truncatedDetail = Maps.newHashMap();
            for (Map.Entry<String, ?> entry : detail.entrySet()) {
                truncatedDetail.put(MessageImpl.truncateDetailIfNeeded(entry.getKey()), MessageImpl.truncate(entry.getValue()));
            }
            return truncatedDetail;
        }

        @Nullable
        private static Object truncate(@Nullable Object value) {
            if (value instanceof Map) {
                return MessageImpl.truncateDetailNested((Map)value);
            }
            if (value instanceof List) {
                return MessageImpl.truncateDetail((List)value);
            }
            if (value instanceof Optional) {
                return MessageImpl.truncateDetailIfNeeded((Optional)value);
            }
            if (value instanceof String) {
                return MessageImpl.truncateDetailIfNeeded((String)value);
            }
            return value;
        }

        private static Map<?, ?> truncateDetailNested(Map<?, ?> detail) {
            HashMap truncatedDetail = Maps.newHashMap();
            for (Map.Entry<?, ?> entry : detail.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = MessageImpl.truncateDetailIfNeeded((String)key);
                }
                truncatedDetail.put(key, MessageImpl.truncate(entry.getValue()));
            }
            return truncatedDetail;
        }

        private static List<Object> truncateDetail(List<?> detail) {
            ArrayList truncatedDetail = Lists.newArrayList();
            for (Object value : detail) {
                truncatedDetail.add(MessageImpl.truncate(value));
            }
            return truncatedDetail;
        }

        private static Optional<?> truncateDetailIfNeeded(Optional<?> optional) {
            if (!optional.isPresent()) {
                return optional;
            }
            Object value = optional.get();
            if (!(value instanceof String)) {
                return optional;
            }
            String val = (String)value;
            if (MessageImpl.needsTruncateDetail(val)) {
                return Optional.of((Object)MessageImpl.truncateDetailIfNeeded(val));
            }
            return optional;
        }

        private static String truncateDetailIfNeeded(String s) {
            if (s.length() <= MESSAGE_DETAIL_CHAR_LIMIT) {
                return s;
            }
            return s.substring(0, MESSAGE_DETAIL_CHAR_LIMIT) + " [truncated to " + MESSAGE_DETAIL_CHAR_LIMIT + " characters]";
        }
    }
}

